/*
 * Copyright(c) Yale University, 2008.  All rights reserved.
 * (See licensing and redistribution disclosures in licensing project directory.)
 * 
 */
package org.jasig.portlet.search.mvc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.AbstractController;

/**
 * TabbedSearchController is the main portlet controller for the tabbed search
 * portlet.
 * 
 * @author Jen Bourey
 */
public class TabbedSearchController extends AbstractController {

	private static Log log = LogFactory.getLog(TabbedSearchController.class);
	private List<String> gsaSearchEngines;
	private List<ConfiguredSearch> configuredSearches;
	
	/*
	 * (non-Javadoc)
	 * @see org.springframework.web.portlet.mvc.AbstractController#handleRenderRequest(javax.portlet.RenderRequest, javax.portlet.RenderResponse)
	 */
	@Override
	public ModelAndView handleRenderRequest(
			RenderRequest request, RenderResponse response) throws Exception {

		Map<String, Object> model = new HashMap<String, Object>();
		
		// if the user is currently logged in, save a logged in flag in the session
		PortletSession session = request.getPortletSession();
		if (request.getRemoteUser() != null)
			session.setAttribute("loggedIn", true, PortletSession.APPLICATION_SCOPE);
		
		List<ConfiguredSearch> allowedSearches = new ArrayList<ConfiguredSearch>();
		for (ConfiguredSearch search : this.configuredSearches) {
			for (String role : search.getRoles()) {
				if (request.isUserInRole(role)) {
					allowedSearches.add(search);
					break;
				}
			}
		}
		session.setAttribute("allowedSearches", allowedSearches, PortletSession.APPLICATION_SCOPE);
		
		model.put("configuredSearches", allowedSearches);
		model.put("gsaSearchEngines", this.gsaSearchEngines);
		
		return new ModelAndView("/index", "model", model);
	}

	/**
	 * Set the list of GSA search sites.
	 * 
	 * @param gsaSearchEngines
	 */
	public void setGsaSearchEngines(List<String> gsaSearchEngines) {
		this.gsaSearchEngines = gsaSearchEngines;
	}
	
	/**
	 * Set the list of configured search engines.  Search tabs will be displayed
	 * in the order represented in this list.
	 * 
	 * @param configuredSearches
	 */
	public void setConfiguredSearches(List<ConfiguredSearch> configuredSearches) {
		this.configuredSearches = configuredSearches;
	}
	
	
}
