/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jasig.portlet.search.ldap;

import java.util.List;

/**
 * 
 * @author Jen Bourey
 * @revision $Revision: 46837 $
 */
public class PersonAttribute {
	
	private String key;
	private String display;
	private List<String> roles;
	
	public PersonAttribute() { }
	
	public PersonAttribute(String ldapKey, String type, List<String> roles) {
		this.key = ldapKey;
		this.display = type;
		this.roles = roles;
	}
	
	public String getKey() {
		return this.key;
	}
	public void setKey(String ldapKey) {
		this.key = ldapKey;
	}
	public List<String> getRoles() {
		return this.roles;
	}
	public void setRoles(List<String> roles) {
		this.roles = roles;
	}

	public String getDisplay() {
		return this.display;
	}

	public void setDisplay(String display) {
		this.display = display;
	}

}
