/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jasig.portlet.search.mvc;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

/**
 * GoogleSearchFrameController constructs data for a google search IFrame.
 * 
 * @author Jen Bourey
 * @version $Revision: 47825 $
 */
@Controller
@RequestMapping("/googleSearch")
public class GoogleSearchFrameController {

	private static Log log = LogFactory.getLog(GoogleSearchFrameController.class);
	
	
	@RequestMapping(method = RequestMethod.GET)
	public ModelAndView searchGoogle(HttpServletRequest request) {

		// find the appropriate google key for this server
		String serverAddress = request.getServerName();
		if (request.getServerPort() != 80 && request.getServerPort() != 443)
			serverAddress = serverAddress.concat(":" + request.getServerPort());
		log.debug("retrieving google key for server " + serverAddress);
		log.debug("found key " + googleKeys.get(serverAddress));

		Map<String, Object> model = new HashMap<String, Object>();
		model.put("googleKey", (String) googleKeys.get(serverAddress));
		
		return new ModelAndView("/googleSearchFrame", "model", model);
	}

	
	private Map<String,String> googleKeys;
	
	/**
	 * Set a map of Google search API keys to use.  Map keys should be 
	 * of the format host[:port] and should map to the appropriate API 
	 * key for that server.
	 * 
	 * @param keys
	 */
	@Resource(name="googleApiKeys")
	public void setGoogleKeys(Map<String,String> keys) {
		this.googleKeys = keys;
	}
	
}
