/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jasig.portlet.search.mvc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.search.ldap.LdapSearchServiceImpl;
import org.jasig.portlet.search.ldap.Person;
import org.jasig.web.service.AjaxPortletSupportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.LimitExceededException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * PersonSearchController performs directory searches for person information
 * against an LDAP directory.
 * 
 * @author Jen Bourey
 */
@Controller
@RequestMapping("VIEW")
public class PersonSearchController {

	private static Log log = LogFactory.getLog(PersonSearchController.class);
	
	@RequestMapping(params = "action=personSearch")
	public void searchPersonDirectory(ActionRequest request, ActionResponse response) throws Exception {
		Map<String, Object> model = new HashMap<String, Object>();

		// perform the search
		List<Person> people = null;
		try {
			people = personSearchService.searchDirectory(request.getParameter("name"), request);
		} catch (LimitExceededException e) {
			model.put("sizeLimitExceeded", true);
			if (log.isDebugEnabled()) {
				log.debug("LDAP search size limit exceeded for search '" 
						+ request.getParameter("name") + "'");
			}
		}

		// add our list of people to the model and return the model and view
		model.put("people", people);
		model.put("attributes", personSearchService.getAttributeTypeMap());
		
		ajaxPortletSupportService.redirectAjaxResponse("ajax/directory", model, request, response);
	}

	private AjaxPortletSupportService ajaxPortletSupportService;
	
	@Autowired(required = true)
	public void setAjaxPortletSupportService(AjaxPortletSupportService ajaxPortletSupportService) {
		this.ajaxPortletSupportService = ajaxPortletSupportService;
	}
	
	private LdapSearchServiceImpl personSearchService;

	@Autowired(required = true)
	public void setPersonSearchService(LdapSearchServiceImpl searchService) {
		this.personSearchService = searchService;
	}
	
}
