/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jasig.portlet.search.mvc;

import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping("/ajax/vcard.vcf")
public class VCardController {

	@RequestMapping(method = RequestMethod.POST)
	public void showVCard(HttpServletRequest request, HttpServletResponse response, OutputStream stream) throws IOException{
		response.setContentType("text/x-vCard; charset=utf-8;");
		
		StringTemplateGroup group = new StringTemplateGroup("vcard", vcardTemplate.getFile().getParent());
		StringTemplate template = group.getInstanceOf(vcardTemplate.getFilename().replace(".st", ""));
		for (Object paramName : request.getParameterMap().keySet()){
			String strName = (String) paramName;
			template.setAttribute(strName, request.getParameter(strName));
		}
		String vcard = template.toString();
		stream.write(vcard.getBytes());
	}
	
	private Resource vcardTemplate;
	
	/**
	 * Set the VCard template file to be used.
	 * 
	 * @param vcardTemplate
	 */
	public void setVCardTemplate(Resource vcardTemplate) {
		this.vcardTemplate = vcardTemplate;
	}

}
