<%--

    Licensed to Jasig under one or more contributor license
    agreements. See the NOTICE file distributed with this work
    for additional information regarding copyright ownership.
    Jasig licenses this file to you under the Apache License,
    Version 2.0 (the "License"); you may not use this file
    except in compliance with the License. You may obtain a
    copy of the License at:

    http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on
    an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied. See the License for the
    specific language governing permissions and limitations
    under the License.

--%>
<jsp:directive.include file="/WEB-INF/jsp/include.jsp"/>

<c:if test="${ sizeLimitExceeded }">
	<p class="portlet-msg-error"><spring:message code="person.search.limitExceeded"/></p>
</c:if>

<c:forEach items="${ people }" var="person" varStatus="status">
    <div class="${ fn:length(people) == 1 ? 'activeLdapPerson' : 'inactiveLdapPerson' }" style="margin-bottom:0px;margin-top:10px;">
        <a class="ldapPersonLink" href="javascript:;" style="text-decoration:none;">
            <c:out value="${person.fullName}" />
        </a>
    	<table class="ldapResults">
			<c:forEach items="${ person.attributes }" var="attr">
                <c:if test="${ attributes[attr.key] != 'none' }">
		    		<tr>
		    			<td class="ldapResultKey">
							<spring:message code="person.${attr.key}" text="${attr.key}" />
						</td>
						<td class="ldapResultValue">
						   <c:choose>
						       <c:when test="${ attributes[attr.key] == 'email' }">
						           <a href="mailto:${ attr.value }">${ attr.value }</a>
						       </c:when>
	                           <c:when test="${ attributes[attr.key] == 'phone' }">
	                               <a href="tel:${ attr.value }">${ attr.value }</a>
	                           </c:when>
	                           <c:when test="${ attributes[attr.key] == 'address' }">
	                               <a href="http://maps.google.com/maps?z=16&t=m&q=${ attr.value }">${ attr.value }</a>
	                           </c:when>
						       <c:otherwise>${ attr.value }</c:otherwise>
						   </c:choose>
						</td>
					</tr>
				</c:if>
			</c:forEach>
			<tr>
			    <td colspan="2">
			        <a target="_blank" href="javascript:;" personIndex="${ status.index }" class="vcard-link">
			            <img src="<rs:resourceURL value="/rs/famfamfam/silk/1.3/book_addresses.png"/>"/>
			            Add to address book</a>
			    </td>
			</tr>
		</table>
	</div>
</c:forEach>

<script type="text/javascript">
var people = [<c:forEach items="${ people }" var="person" varStatus="status">{name: '<spring:escapeBody javaScriptEscape="true">${person.fullName}</spring:escapeBody>', attributes:{<c:forEach items="${ person.attributes }" var="attr" varStatus="attrStatus">${attr.key}: '<spring:escapeBody javaScriptEscape="true">${attr.value}</spring:escapeBody>'${ attrStatus.last ? '' : ', '}</c:forEach>}}${ status.last ? '' : ', '}</c:forEach>];
</script>