/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.utils.jdbc;

import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.apache.tomcat.jdbc.pool.Validator;
import org.jasig.portlet.utils.jdbc.DelayedValidationQueryResolver;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class TomcatDataSourceFactory
extends AbstractFactoryBean<DataSource>
implements BeanNameAware,
PoolConfiguration {
    private final PoolConfiguration poolConfiguration = new PoolProperties();
    private MBeanServer mBeanServer;
    private String baseObjectName;
    private DelayedValidationQueryResolver delayedValidationQueryResolver;
    private ObjectName objectName;

    public void setBeanName(String name) {
        this.poolConfiguration.setName(name);
    }

    @Autowired(required=false)
    public void setmBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    @Autowired(required=false)
    public void setDelayedValidationQueryResolver(DelayedValidationQueryResolver delayedValidationQueryResolver) {
        this.delayedValidationQueryResolver = delayedValidationQueryResolver;
    }

    public void setBaseObjectName(String baseObjectName) {
        this.baseObjectName = baseObjectName;
    }

    public Class<?> getObjectType() {
        return DataSource.class;
    }

    protected DataSource createInstance() throws Exception {
        final DataSource dataSource = new DataSource(this.poolConfiguration);
        if (this.mBeanServer != null) {
            try {
                ConnectionPool pool = dataSource.createPool();
                org.apache.tomcat.jdbc.pool.jmx.ConnectionPool jmxPool = pool.getJmxPool();
                this.objectName = ObjectName.getInstance(this.baseObjectName + this.poolConfiguration.getName());
                this.logger.info((Object)("Registering DataSource " + this.poolConfiguration.getName() + " in MBeanServer under name: " + this.objectName));
                ObjectInstance instance = this.mBeanServer.registerMBean(jmxPool, this.objectName);
                this.objectName = instance.getObjectName();
            }
            catch (Exception e) {
                this.logger.warn((Object)("Failed to register connection pool with MBeanServer. JMX information will not be available for: " + this.poolConfiguration.getName()), (Throwable)e);
            }
        }
        if (dataSource.getValidationQuery() == null && this.delayedValidationQueryResolver != null) {
            this.logger.info((Object)("Attempting to resolve validation query for: " + this.poolConfiguration.getName()));
            try {
                this.delayedValidationQueryResolver.registerValidationQueryCallback((javax.sql.DataSource)dataSource, new DelayedValidationQueryResolver.ValidationQueryRegistrationHandler(){

                    @Override
                    public void setValidationQuery(String validationQuery) {
                        TomcatDataSourceFactory.this.logger.info((Object)("Resolved validation query '" + validationQuery + "' for " + TomcatDataSourceFactory.this.poolConfiguration.getName()));
                        dataSource.setValidationQuery(validationQuery);
                    }
                });
            }
            catch (Exception e) {
                this.logger.warn((Object)("Failed to resolve validation query for: " + this.poolConfiguration.getName()), (Throwable)e);
            }
        }
        return dataSource;
    }

    protected void destroyInstance(DataSource instance) throws Exception {
        if (this.objectName != null) {
            try {
                this.mBeanServer.unregisterMBean(this.objectName);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Failed to unregister connection pool with MBeanServer for: " + this.poolConfiguration.getName()), (Throwable)e);
            }
        }
        instance.close();
    }

    public void setAbandonWhenPercentageFull(int percentage) {
        this.poolConfiguration.setAbandonWhenPercentageFull(percentage);
    }

    public int getAbandonWhenPercentageFull() {
        return this.poolConfiguration.getAbandonWhenPercentageFull();
    }

    public boolean isFairQueue() {
        return this.poolConfiguration.isFairQueue();
    }

    public void setFairQueue(boolean fairQueue) {
        this.poolConfiguration.setFairQueue(fairQueue);
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.poolConfiguration.isAccessToUnderlyingConnectionAllowed();
    }

    public void setAccessToUnderlyingConnectionAllowed(boolean accessToUnderlyingConnectionAllowed) {
        this.poolConfiguration.setAccessToUnderlyingConnectionAllowed(accessToUnderlyingConnectionAllowed);
    }

    public String getConnectionProperties() {
        return this.poolConfiguration.getConnectionProperties();
    }

    public void setConnectionProperties(String connectionProperties) {
        this.poolConfiguration.setConnectionProperties(connectionProperties);
    }

    public Properties getDbProperties() {
        return this.poolConfiguration.getDbProperties();
    }

    public void setDbProperties(Properties dbProperties) {
        this.poolConfiguration.setDbProperties(dbProperties);
    }

    public Boolean isDefaultAutoCommit() {
        return this.poolConfiguration.isDefaultAutoCommit();
    }

    public Boolean getDefaultAutoCommit() {
        return this.poolConfiguration.getDefaultAutoCommit();
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.poolConfiguration.setDefaultAutoCommit(defaultAutoCommit);
    }

    public String getDefaultCatalog() {
        return this.poolConfiguration.getDefaultCatalog();
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.poolConfiguration.setDefaultCatalog(defaultCatalog);
    }

    public Boolean isDefaultReadOnly() {
        return this.poolConfiguration.isDefaultReadOnly();
    }

    public Boolean getDefaultReadOnly() {
        return this.poolConfiguration.getDefaultReadOnly();
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.poolConfiguration.setDefaultReadOnly(defaultReadOnly);
    }

    public int getDefaultTransactionIsolation() {
        return this.poolConfiguration.getDefaultTransactionIsolation();
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.poolConfiguration.setDefaultTransactionIsolation(defaultTransactionIsolation);
    }

    public String getDriverClassName() {
        return this.poolConfiguration.getDriverClassName();
    }

    public void setDriverClassName(String driverClassName) {
        this.poolConfiguration.setDriverClassName(driverClassName);
    }

    public int getInitialSize() {
        return this.poolConfiguration.getInitialSize();
    }

    public void setInitialSize(int initialSize) {
        this.poolConfiguration.setInitialSize(initialSize);
    }

    public boolean isLogAbandoned() {
        return this.poolConfiguration.isLogAbandoned();
    }

    public void setLogAbandoned(boolean logAbandoned) {
        this.poolConfiguration.setLogAbandoned(logAbandoned);
    }

    public int getMaxActive() {
        return this.poolConfiguration.getMaxActive();
    }

    public void setMaxActive(int maxActive) {
        this.poolConfiguration.setMaxActive(maxActive);
    }

    public int getMaxIdle() {
        return this.poolConfiguration.getMaxIdle();
    }

    public void setMaxIdle(int maxIdle) {
        this.poolConfiguration.setMaxIdle(maxIdle);
    }

    public int getMaxWait() {
        return this.poolConfiguration.getMaxWait();
    }

    public void setMaxWait(int maxWait) {
        this.poolConfiguration.setMaxWait(maxWait);
    }

    public int getMinEvictableIdleTimeMillis() {
        return this.poolConfiguration.getMinEvictableIdleTimeMillis();
    }

    public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
        this.poolConfiguration.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    public int getMinIdle() {
        return this.poolConfiguration.getMinIdle();
    }

    public void setMinIdle(int minIdle) {
        this.poolConfiguration.setMinIdle(minIdle);
    }

    public String getName() {
        return this.poolConfiguration.getName();
    }

    public void setName(String name) {
        this.poolConfiguration.setName(name);
    }

    public int getNumTestsPerEvictionRun() {
        return this.poolConfiguration.getNumTestsPerEvictionRun();
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.poolConfiguration.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    public String getPassword() {
        return this.poolConfiguration.getPassword();
    }

    public void setPassword(String password) {
        this.poolConfiguration.setPassword(password);
    }

    public String getPoolName() {
        return this.poolConfiguration.getPoolName();
    }

    public String getUsername() {
        return this.poolConfiguration.getUsername();
    }

    public void setUsername(String username) {
        this.poolConfiguration.setUsername(username);
    }

    public boolean isRemoveAbandoned() {
        return this.poolConfiguration.isRemoveAbandoned();
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.poolConfiguration.setRemoveAbandoned(removeAbandoned);
    }

    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        this.poolConfiguration.setRemoveAbandonedTimeout(removeAbandonedTimeout);
    }

    public int getRemoveAbandonedTimeout() {
        return this.poolConfiguration.getRemoveAbandonedTimeout();
    }

    public boolean isTestOnBorrow() {
        return this.poolConfiguration.isTestOnBorrow();
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.poolConfiguration.setTestOnBorrow(testOnBorrow);
    }

    public boolean isTestOnReturn() {
        return this.poolConfiguration.isTestOnReturn();
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.poolConfiguration.setTestOnReturn(testOnReturn);
    }

    public boolean isTestWhileIdle() {
        return this.poolConfiguration.isTestWhileIdle();
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.poolConfiguration.setTestWhileIdle(testWhileIdle);
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this.poolConfiguration.getTimeBetweenEvictionRunsMillis();
    }

    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.poolConfiguration.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    public String getUrl() {
        return this.poolConfiguration.getUrl();
    }

    public void setUrl(String url) {
        this.poolConfiguration.setUrl(url);
    }

    public String getValidationQuery() {
        return this.poolConfiguration.getValidationQuery();
    }

    public void setValidationQuery(String validationQuery) {
        this.poolConfiguration.setValidationQuery(validationQuery);
    }

    public String getValidatorClassName() {
        return this.poolConfiguration.getValidatorClassName();
    }

    public void setValidatorClassName(String className) {
        this.poolConfiguration.setValidatorClassName(className);
    }

    public Validator getValidator() {
        return this.poolConfiguration.getValidator();
    }

    public void setValidator(Validator validator) {
        this.poolConfiguration.setValidator(validator);
    }

    public long getValidationInterval() {
        return this.poolConfiguration.getValidationInterval();
    }

    public void setValidationInterval(long validationInterval) {
        this.poolConfiguration.setValidationInterval(validationInterval);
    }

    public String getInitSQL() {
        return this.poolConfiguration.getInitSQL();
    }

    public void setInitSQL(String initSQL) {
        this.poolConfiguration.setInitSQL(initSQL);
    }

    public boolean isTestOnConnect() {
        return this.poolConfiguration.isTestOnConnect();
    }

    public void setTestOnConnect(boolean testOnConnect) {
        this.poolConfiguration.setTestOnConnect(testOnConnect);
    }

    public String getJdbcInterceptors() {
        return this.poolConfiguration.getJdbcInterceptors();
    }

    public void setJdbcInterceptors(String jdbcInterceptors) {
        this.poolConfiguration.setJdbcInterceptors(jdbcInterceptors);
    }

    public PoolProperties.InterceptorDefinition[] getJdbcInterceptorsAsArray() {
        return this.poolConfiguration.getJdbcInterceptorsAsArray();
    }

    public boolean isJmxEnabled() {
        return this.poolConfiguration.isJmxEnabled();
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.poolConfiguration.setJmxEnabled(jmxEnabled);
    }

    public boolean isPoolSweeperEnabled() {
        return this.poolConfiguration.isPoolSweeperEnabled();
    }

    public boolean isUseEquals() {
        return this.poolConfiguration.isUseEquals();
    }

    public void setUseEquals(boolean useEquals) {
        this.poolConfiguration.setUseEquals(useEquals);
    }

    public long getMaxAge() {
        return this.poolConfiguration.getMaxAge();
    }

    public void setMaxAge(long maxAge) {
        this.poolConfiguration.setMaxAge(maxAge);
    }

    public boolean getUseLock() {
        return this.poolConfiguration.getUseLock();
    }

    public void setUseLock(boolean useLock) {
        this.poolConfiguration.setUseLock(useLock);
    }

    public void setSuspectTimeout(int seconds) {
        this.poolConfiguration.setSuspectTimeout(seconds);
    }

    public int getSuspectTimeout() {
        return this.poolConfiguration.getSuspectTimeout();
    }

    public void setDataSource(Object ds) {
        this.poolConfiguration.setDataSource(ds);
    }

    public Object getDataSource() {
        return this.poolConfiguration.getDataSource();
    }

    public void setDataSourceJNDI(String jndiDS) {
        this.poolConfiguration.setDataSourceJNDI(jndiDS);
    }

    public String getDataSourceJNDI() {
        return this.poolConfiguration.getDataSourceJNDI();
    }

    public boolean isAlternateUsernameAllowed() {
        return this.poolConfiguration.isAlternateUsernameAllowed();
    }

    public void setAlternateUsernameAllowed(boolean alternateUsernameAllowed) {
        this.poolConfiguration.setAlternateUsernameAllowed(alternateUsernameAllowed);
    }

    public void setCommitOnReturn(boolean commitOnReturn) {
        this.poolConfiguration.setCommitOnReturn(commitOnReturn);
    }

    public boolean getCommitOnReturn() {
        return this.poolConfiguration.getCommitOnReturn();
    }

    public void setRollbackOnReturn(boolean rollbackOnReturn) {
        this.poolConfiguration.setRollbackOnReturn(rollbackOnReturn);
    }

    public boolean getRollbackOnReturn() {
        return this.poolConfiguration.getRollbackOnReturn();
    }

    public void setUseDisposableConnectionFacade(boolean useDisposableConnectionFacade) {
        this.poolConfiguration.setUseDisposableConnectionFacade(useDisposableConnectionFacade);
    }

    public boolean getUseDisposableConnectionFacade() {
        return this.poolConfiguration.getUseDisposableConnectionFacade();
    }

    public void setLogValidationErrors(boolean logValidationErrors) {
        this.poolConfiguration.setLogValidationErrors(logValidationErrors);
    }

    public boolean getLogValidationErrors() {
        return this.poolConfiguration.getLogValidationErrors();
    }

    public boolean getPropagateInterruptState() {
        return this.poolConfiguration.getPropagateInterruptState();
    }

    public void setPropagateInterruptState(boolean propagateInterruptState) {
        this.poolConfiguration.setPropagateInterruptState(propagateInterruptState);
    }
}

