/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.spring;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.portlet.PortletRequest;
import org.jasig.portlet.spring.DefaultPropertyAccessor;
import org.jasig.portlet.spring.IExpressionProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Service;

@Service
public class SpringELProcessor
implements IExpressionProcessor,
BeanFactoryAware {
    private static final ParserContext PARSER_CONTEXT = new TemplateParserContext("${", "}");
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private BeanResolver beanResolver;
    private Properties properties = new Properties();

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanResolver = new BeanFactoryResolver(beanFactory);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String process(String value, PortletRequest request) {
        Map<String, Object> context = this.getContext(request);
        StandardEvaluationContext sec = new StandardEvaluationContext(context);
        sec.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        sec.addPropertyAccessor((PropertyAccessor)new ReflectivePropertyAccessor());
        sec.addPropertyAccessor((PropertyAccessor)new DefaultPropertyAccessor(PARSER_CONTEXT.getExpressionPrefix(), PARSER_CONTEXT.getExpressionSuffix()));
        if (this.beanResolver != null) {
            sec.setBeanResolver(this.beanResolver);
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        try {
            String processed = (String)parser.parseExpression(value, PARSER_CONTEXT).getValue((EvaluationContext)sec, String.class);
            return processed;
        }
        catch (SpelEvaluationException e) {
            throw new EvaluationException("Failed to process string '" + value + "'. See nested error message and check your SpEL tokens in your string", (Throwable)e);
        }
    }

    private Map<String, Object> getContext(PortletRequest request) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("property", this.properties);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            requestMap.put(name, request.getParameter(name));
        }
        context.put("server", request.getServerName());
        context.put("port", request.getServerPort());
        context.put("protocol", request.getScheme());
        context.put("contextPath", request.getContextPath());
        context.put("request", request);
        context.put("requestParam", requestMap);
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        context.put("user", userInfo);
        return context;
    }
}

