/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jasig.springframework.security.portlet.authentication;

import javax.portlet.PortletRequest;

import org.apache.commons.lang.StringUtils;
import org.jasig.springframework.security.portlet.util.AuthenticationValidator;
import org.springframework.security.core.Authentication;

public class PrimaryAttributePortletAuthenticationValidator implements AuthenticationValidator {
	
	private PrimaryAttributePortletPreAuthenticatedAuthenticationDetailsSource preAuthenticationDetailsSource;
	
	public void setPreAuthenticationDetailsSource(PrimaryAttributePortletPreAuthenticatedAuthenticationDetailsSource value) {
		preAuthenticationDetailsSource = value;
	}
	
	@Override
	public boolean validate(Authentication authentication, PortletRequest request) {
		
		//get current request value
		String currentValue = preAuthenticationDetailsSource.getPrimaryUserAttribute(request);
		
		//get cached value
		final PrimaryAttributePortletAuthenticationDetails authenticationDetails = (PrimaryAttributePortletAuthenticationDetails)authentication.getDetails();
        String cachedValue = authenticationDetails.getPrimaryAttribute();
		
        //return if those values changed or not
        return StringUtils.equals(currentValue, cachedValue);
	}

}
