/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.springframework.security.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jasig.web.filter.SimpleCorsFilter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ComponentCorsFilter
extends SimpleCorsFilter {
    @Value(value="${cors.filter.allowed.headers:Origin,X-Requested-With,Content-Type,Accept}")
    private String headers;
    @Value(value="${cors.filter.max.age:3600}")
    private String maxAgeInSeconds;
    @Value(value="${cors.filter.allowed.methods:POST,GET,PUT,OPTIONS,DELETE,HEAD}")
    private String method;
    @Value(value="${cors.filter.allowed.origin:*}")
    private String origin;

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        System.out.println("Using: " + this.headers + " " + this.method + " " + this.origin);
        this.setAllowHeaders(this.headers);
        this.setAllowMethod(this.method);
        this.setAllowOrigin(this.origin);
        this.setMaxAge(this.maxAgeInSeconds);
        super.doFilter(req, res, chain);
    }
}

