/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.springframework.security.portlet.authentication;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.springframework.security.portlet.authentication.PortletPreAuthenticatedAuthenticationDetailsSource;
import org.jasig.springframework.security.portlet.authentication.PreAuthenticatedGrantedAuthoritiesPortletAuthenticationDetails;
import org.jasig.springframework.security.portlet.authentication.PrimaryAttributePortletAuthenticationDetails;
import org.springframework.security.access.AccessDeniedException;

public class PrimaryAttributePortletPreAuthenticatedAuthenticationDetailsSource
extends PortletPreAuthenticatedAuthenticationDetailsSource {
    private String primaryUserAttributesPreference = "primaryAttribute";

    public void setPrimaryUserAttributesPreference(String primaryUserAttributesPreference) {
        this.primaryUserAttributesPreference = primaryUserAttributesPreference;
    }

    public PreAuthenticatedGrantedAuthoritiesPortletAuthenticationDetails buildDetails(PortletRequest context) {
        Collection userGas = this.buildGrantedAuthorities(context);
        String primaryUserAttribute = this.getPrimaryUserAttribute(context);
        PrimaryAttributePortletAuthenticationDetails result = new PrimaryAttributePortletAuthenticationDetails(context, userGas, primaryUserAttribute);
        return result;
    }

    public final String getPrimaryUserAttribute(PortletRequest request) {
        Object[] attributeNames;
        PortletPreferences preferences = request.getPreferences();
        Map userAttributes = (Map)request.getAttribute("javax.portlet.userinfo");
        for (String string : attributeNames = preferences.getValues(this.primaryUserAttributesPreference, new String[0])) {
            String emplid = (String)userAttributes.get(string);
            if (!StringUtils.isNotEmpty((String)emplid)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found emplid '" + emplid + "' for under attribute: " + string));
            }
            return emplid;
        }
        this.logger.warn((Object)("Could not find a value for any of the user attributes " + Arrays.toString(attributeNames) + " specified by preference: " + this.primaryUserAttributesPreference));
        throw new AccessDeniedException("No primary attribute found in attributes: " + Arrays.toString(attributeNames));
    }
}

