/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class SimpleCorsFilter
implements Filter {
    private String allowHeaders = "Origin, X-Requested-With, Content-Type, Accept";
    private String allowMethod = "POST, GET, PUT, OPTIONS, DELETE, HEAD";
    private String allowOrigin = "*";
    private String maxAge = "3600";

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)res;
        response.setHeader("Access-Control-Allow-Origin", this.allowOrigin);
        response.setHeader("Access-Control-Allow-Methods", this.allowMethod);
        response.setHeader("Access-Control-Max-Age", this.maxAge);
        response.setHeader("Access-Control-Allow-Headers", this.allowHeaders);
        chain.doFilter(req, res);
    }

    public void init(FilterConfig filterConfig) {
        String value = filterConfig.getInitParameter("allowOrigin");
        if (!StringUtils.isEmpty((String)value)) {
            this.allowOrigin = value;
        }
        if (!StringUtils.isEmpty((String)(value = filterConfig.getInitParameter("allowMethod")))) {
            this.allowMethod = value;
        }
        if (!StringUtils.isEmpty((String)(value = filterConfig.getInitParameter("maxAge")))) {
            this.maxAge = value;
        }
        if (!StringUtils.isEmpty((String)(value = filterConfig.getInitParameter("allowHeaders")))) {
            this.allowHeaders = value;
        }
    }

    public void setAllowHeaders(String allowHeaders) {
        this.allowHeaders = allowHeaders;
    }

    public void setAllowMethod(String allowMethod) {
        this.allowMethod = allowMethod;
    }

    public void setAllowOrigin(String allowOrigin) {
        this.allowOrigin = allowOrigin;
    }

    public void setMaxAge(String maxAge) {
        this.maxAge = maxAge;
    }
}

