/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.springframework.mockito;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mockito.Mockito;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class MockitoFactoryBean<T>
extends AbstractFactoryBean<T> {
    private static final Set<Object> MOCK_CACHE = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Class<? extends T> type;

    public static void resetAllMocks() {
        Mockito.reset((Object[])MOCK_CACHE.toArray());
    }

    public MockitoFactoryBean(Class<? extends T> type) {
        this.type = type;
    }

    public Class<? extends T> getObjectType() {
        return this.type;
    }

    protected T createInstance() throws Exception {
        Object mock = Mockito.mock(this.type);
        MOCK_CACHE.add(mock);
        return (T)mock;
    }

    protected void destroyInstance(T instance) throws Exception {
        MOCK_CACHE.remove(instance);
    }
}

