/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.springframework.web.client;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.ResourceResponse;
import org.jasig.springframework.web.client.ExtendedRestOperations;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;

public class PortletResourceProxyResponse
implements ExtendedRestOperations.ProxyResponse {
    private final ResourceResponse resourceResponse;
    private final Set<String> excludedHeaders;

    public PortletResourceProxyResponse(ResourceResponse resourceResponse) {
        this.resourceResponse = resourceResponse;
        this.excludedHeaders = Collections.emptySet();
    }

    public PortletResourceProxyResponse(ResourceResponse resourceResponse, Set<String> excludedHeaders) {
        this.resourceResponse = resourceResponse;
        this.excludedHeaders = ImmutableSet.copyOf(excludedHeaders);
    }

    @Override
    public void setHttpStatus(HttpStatus status) {
        this.resourceResponse.setProperty("portlet.http-status-code", Integer.toString(status.value()));
    }

    @Override
    public void setHttpHeaders(HttpHeaders headers) {
        for (Map.Entry entry : headers.entrySet()) {
            String headerName = (String)entry.getKey();
            if (this.excludedHeaders.contains(headerName)) continue;
            for (String headerValue : (List)entry.getValue()) {
                this.resourceResponse.addProperty(headerName, headerValue);
            }
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.resourceResponse.getPortletOutputStream();
    }
}

