/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.springframework.http.converter.xml;

import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.xml.AbstractXmlHttpMessageConverter;
import org.springframework.util.Assert;

public class JaxbMarshallingHttpMessageConverter
extends AbstractXmlHttpMessageConverter<Object> {
    private JAXBContext jaxbContext;

    public JaxbMarshallingHttpMessageConverter(JAXBContext jaxbContext) {
        Assert.notNull((Object)jaxbContext, (String)"JAXBContext must not be null");
        this.jaxbContext = jaxbContext;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    protected Object readFromSource(Class<?> clazz, HttpHeaders headers, Source source) throws IOException {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            Object result = unmarshaller.unmarshal(source, clazz);
            if (result instanceof JAXBElement) {
                result = result.getValue();
            }
            if (!clazz.isInstance(result)) {
                throw new TypeMismatchException(result, clazz);
            }
            return result;
        }
        catch (JAXBException e) {
            throw new HttpMessageNotReadableException("Could not read [" + clazz + "]", (Throwable)e);
        }
    }

    protected void writeToResult(Object o, HttpHeaders headers, Result result) throws IOException {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.marshal(o, result);
        }
        catch (JAXBException e) {
            throw new HttpMessageNotWritableException("Could not write [" + o + "]", (Throwable)e);
        }
    }
}

