/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.apache.http.impl.conn.jmx;

import java.util.concurrent.TimeUnit;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.pool.PoolStats;
import org.jasig.apache.http.impl.conn.jmx.ConnPoolControlDataMXBean;
import org.springframework.beans.factory.annotation.Autowired;

public class ConnPoolControlData<T>
implements ConnPoolControlDataMXBean {
    private final long POOL_STATS_REFRESH = TimeUnit.SECONDS.toNanos(1L);
    private ConnPoolControl<T> connPoolControl;
    private volatile long lastLoaded = System.nanoTime();
    private volatile PoolStats poolStats;

    @Autowired
    public void setConnPoolControl(ConnPoolControl<T> connPoolControl) {
        this.connPoolControl = connPoolControl;
    }

    @Override
    public void setMaxTotal(int max) {
        this.connPoolControl.setMaxTotal(max);
    }

    @Override
    public int getMaxTotal() {
        return this.connPoolControl.getMaxTotal();
    }

    @Override
    public void setDefaultMaxPerRoute(int max) {
        this.connPoolControl.setDefaultMaxPerRoute(max);
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.connPoolControl.getDefaultMaxPerRoute();
    }

    @Override
    public PoolStats getTotalStats() {
        return this.connPoolControl.getTotalStats();
    }

    @Override
    public int getLeased() {
        return this.getPoolStats().getLeased();
    }

    @Override
    public int getPending() {
        return this.getPoolStats().getPending();
    }

    @Override
    public int getAvailable() {
        return this.getPoolStats().getAvailable();
    }

    @Override
    public int getMax() {
        return this.getPoolStats().getMax();
    }

    private PoolStats getPoolStats() {
        PoolStats p = this.poolStats;
        long now = System.nanoTime();
        if (now - this.lastLoaded >= this.POOL_STATS_REFRESH || p == null) {
            p = this.connPoolControl.getTotalStats();
            this.lastLoaded = now;
            this.poolStats = p;
        }
        return p;
    }
}

