/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.springframework.ws.client.core;

import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.destination.DestinationProvider;

public class DestinationOverridingWebServiceTemplate
extends WebServiceTemplate {
    private Integer portOverride = null;

    public void setPortOverride(String portOverride) {
        try {
            this.portOverride = Integer.parseInt(portOverride);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getDefaultUri() {
        DestinationProvider destinationProvider = this.getDestinationProvider();
        if (destinationProvider != null) {
            URI overridenUri;
            URI uri = destinationProvider.getDestination();
            if (uri == null) {
                return null;
            }
            if (this.portOverride == null) {
                return uri.toString();
            }
            try {
                overridenUri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), this.portOverride, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                this.logger.error((Object)("Could not override port on URI " + uri + " to " + this.portOverride), (Throwable)e);
                return uri.toString();
            }
            return overridenUri.toString();
        }
        return null;
    }
}

