/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.apache.http.impl.conn;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanShutdownPoolingClientConnectionManager
extends PoolingClientConnectionManager {
    private final Lock shutdownLock = new ReentrantLock();
    private final AtomicBoolean shutdownComplete = new AtomicBoolean(false);
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private long shutdownThreadKillTime = TimeUnit.SECONDS.toMillis(45L);
    private long shutdownThreadMaxTime = TimeUnit.SECONDS.toMillis(30L);
    private long shutdownThreadMaxWaitTime = TimeUnit.SECONDS.toMillis(1L);
    private long shutdownThreadPollRate = 5L;

    public CleanShutdownPoolingClientConnectionManager() {
    }

    public CleanShutdownPoolingClientConnectionManager(SchemeRegistry schreg, DnsResolver dnsResolver) {
        super(schreg, dnsResolver);
    }

    public CleanShutdownPoolingClientConnectionManager(SchemeRegistry schemeRegistry, long timeToLive, TimeUnit tunit, DnsResolver dnsResolver) {
        super(schemeRegistry, timeToLive, tunit, dnsResolver);
    }

    public CleanShutdownPoolingClientConnectionManager(SchemeRegistry schemeRegistry, long timeToLive, TimeUnit tunit) {
        super(schemeRegistry, timeToLive, tunit);
    }

    public CleanShutdownPoolingClientConnectionManager(SchemeRegistry schreg) {
        super(schreg);
    }

    public void setShutdownThreadKillTime(int shutdownThreadKillTime) {
        this.shutdownThreadKillTime = shutdownThreadKillTime;
    }

    public void setShutdownThreadMaxTime(int shutdownThreadMaxTime) {
        this.shutdownThreadMaxTime = shutdownThreadMaxTime;
    }

    public void setShutdownThreadMaxWaitTime(int shutdownThreadMaxWaitTime) {
        this.shutdownThreadMaxWaitTime = shutdownThreadMaxWaitTime;
    }

    public void setShutdownThreadPollRate(int shutdownThreadPollRate) {
        this.shutdownThreadPollRate = shutdownThreadPollRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdownComplete.get() || !this.shutdownLock.tryLock()) {
            return;
        }
        try {
            long shutdownStart;
            Thread shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        CleanShutdownPoolingClientConnectionManager.this.logger.info("PoolingClientConnectionManager shutdown started");
                        CleanShutdownPoolingClientConnectionManager.super.shutdown();
                    }
                    finally {
                        CleanShutdownPoolingClientConnectionManager.this.shutdownComplete.set(true);
                        CleanShutdownPoolingClientConnectionManager.this.logger.info("PoolingClientConnectionManager shutdown complete");
                    }
                }
            });
            shutdownThread.setName("PoolingClientConnectionManager Shutdown Monitor");
            shutdownThread.setDaemon(true);
            shutdownThread.start();
            long waitStart = shutdownStart = System.nanoTime();
            while (!this.shutdownComplete.get()) {
                long now = System.nanoTime();
                long shutdownTime = TimeUnit.NANOSECONDS.toMillis(now - shutdownStart);
                if (shutdownTime > this.shutdownThreadKillTime) {
                    String stackTrace = CleanShutdownPoolingClientConnectionManager.getStackTrace(shutdownThread);
                    this.logger.error("Shutdown thread " + shutdownThread.getName() + " has been stopping for " + shutdownTime + "ms, killing it. THIS IS BAD. \n" + stackTrace);
                    shutdownThread.stop();
                    break;
                }
                if (shutdownTime > this.shutdownThreadMaxTime) {
                    this.logger.warn("Shutdown thread " + shutdownThread.getName() + " has been stopping for " + shutdownTime + "ms, interrupting immediately");
                    shutdownThread.interrupt();
                } else {
                    Thread.State state = shutdownThread.getState();
                    switch (state) {
                        case BLOCKED: 
                        case TIMED_WAITING: 
                        case WAITING: {
                            long waitTime = TimeUnit.NANOSECONDS.toMillis(now - waitStart);
                            if (waitTime <= this.shutdownThreadMaxWaitTime) break;
                            this.logger.info("Shutdown thread " + shutdownThread.getName() + " has been waiting for " + waitTime + "ms, interrupting");
                            shutdownThread.interrupt();
                        }
                        default: {
                            waitStart = now;
                        }
                    }
                }
                try {
                    Thread.sleep(this.shutdownThreadPollRate);
                }
                catch (InterruptedException e) {}
            }
        }
        finally {
            this.shutdownLock.unlock();
        }
    }

    private static String getStackTrace(Thread t) {
        StackTraceElement[] trace;
        StringBuilder traceBuilder = new StringBuilder();
        for (StackTraceElement element : trace = t.getStackTrace()) {
            traceBuilder.append("\tat ").append(element).append("\n");
        }
        return traceBuilder.toString();
    }
}

