/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.springframework.web.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jasig.springframework.web.client.ExtendedRestOperations;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ExtendedRestTemplate
extends RestTemplate
implements ExtendedRestOperations {
    public ExtendedRestTemplate() {
        List<HeaderSettingClientHttpRequestInterceptor> interceptors = Collections.singletonList(HeaderSettingClientHttpRequestInterceptor.INSTANCE);
        super.setInterceptors(interceptors);
    }

    public ExtendedRestTemplate(ClientHttpRequestFactory requestFactory) {
        super(requestFactory);
        List<HeaderSettingClientHttpRequestInterceptor> interceptors = Collections.singletonList(HeaderSettingClientHttpRequestInterceptor.INSTANCE);
        super.setInterceptors(interceptors);
    }

    public final void setInterceptors(List<ClientHttpRequestInterceptor> interceptors) {
        if (!interceptors.contains(HeaderSettingClientHttpRequestInterceptor.INSTANCE)) {
            ArrayList<ClientHttpRequestInterceptor> newInterceptors = new ArrayList<ClientHttpRequestInterceptor>(interceptors.size() + 1);
            newInterceptors.addAll(newInterceptors);
            newInterceptors.add(HeaderSettingClientHttpRequestInterceptor.INSTANCE);
            interceptors = newInterceptors;
        }
        super.setInterceptors(interceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getForObject(String url, Class<T> responseType, HttpHeaders headers, Object ... urlVariables) throws RestClientException {
        try {
            HeaderSettingClientHttpRequestInterceptor.HEADERS_LOCAL.set(headers);
            Object object = super.getForObject(url, responseType, urlVariables);
            return (T)object;
        }
        finally {
            HeaderSettingClientHttpRequestInterceptor.HEADERS_LOCAL.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int proxyRequest(ExtendedRestOperations.ProxyResponse proxyResponse, String url, HttpMethod method, HttpHeaders headers, Object ... urlVariables) throws RestClientException {
        try {
            HeaderSettingClientHttpRequestInterceptor.HEADERS_LOCAL.set(headers);
            ProxyResponseExtractor responseExtractor = new ProxyResponseExtractor(proxyResponse);
            int n = (Integer)super.execute(url, method, null, (ResponseExtractor)responseExtractor, urlVariables);
            return n;
        }
        finally {
            HeaderSettingClientHttpRequestInterceptor.HEADERS_LOCAL.remove();
        }
    }

    private static class ProxyResponseExtractor
    implements ResponseExtractor<Integer> {
        private final ExtendedRestOperations.ProxyResponse proxyResponse;

        public ProxyResponseExtractor(ExtendedRestOperations.ProxyResponse proxyResponse) {
            this.proxyResponse = proxyResponse;
        }

        public Integer extractData(ClientHttpResponse response) throws IOException {
            HttpStatus statusCode = response.getStatusCode();
            this.proxyResponse.setHttpStatus(statusCode);
            HttpHeaders headers = response.getHeaders();
            this.proxyResponse.setHttpHeaders(headers);
            InputStream body = response.getBody();
            OutputStream outputStream = this.proxyResponse.getOutputStream();
            return IOUtils.copy((InputStream)body, (OutputStream)outputStream);
        }
    }

    private static class HeaderSettingClientHttpRequestInterceptor
    implements ClientHttpRequestInterceptor {
        public static final HeaderSettingClientHttpRequestInterceptor INSTANCE = new HeaderSettingClientHttpRequestInterceptor();
        private static final ThreadLocal<HttpHeaders> HEADERS_LOCAL = new ThreadLocal();

        private HeaderSettingClientHttpRequestInterceptor() {
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            HttpHeaders additionalHeaders = HEADERS_LOCAL.get();
            if (additionalHeaders != null) {
                request.getHeaders().putAll((Map)additionalHeaders);
            }
            return execution.execute(request, body);
        }
    }
}

