/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.springframework.web.client;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.jasig.springframework.web.client.ExtendedRestOperations;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;

public class HttpServletProxyResponse
implements ExtendedRestOperations.ProxyResponse {
    private final HttpServletResponse servletResponse;
    private final Set<String> excludedHeaders;

    public HttpServletProxyResponse(HttpServletResponse servletResponse) {
        this.servletResponse = servletResponse;
        this.excludedHeaders = Collections.emptySet();
    }

    public HttpServletProxyResponse(HttpServletResponse servletResponse, Set<String> excludedHeaders) {
        this.servletResponse = servletResponse;
        this.excludedHeaders = ImmutableSet.copyOf(excludedHeaders);
    }

    @Override
    public void setHttpStatus(HttpStatus status) {
        this.servletResponse.setStatus(status.value());
    }

    @Override
    public void setHttpHeaders(HttpHeaders headers) {
        for (Map.Entry entry : headers.entrySet()) {
            String headerName = (String)entry.getKey();
            if (this.excludedHeaders.contains(headerName)) continue;
            for (String headerValue : (List)entry.getValue()) {
                this.servletResponse.addHeader(headerName, headerValue);
            }
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.servletResponse.getOutputStream();
    }
}

