/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.apache.http.params;

import com.google.common.base.Function;
import java.util.Map;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class HttpParamsBean
implements HttpParams {
    private final HttpParams delegate = new BasicHttpParams();

    public HttpParamsBean(Map<String, Object> parameters) {
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            String name = parameter.getKey();
            Object value = parameter.getValue();
            this.delegate.setParameter(name, value);
        }
    }

    public HttpParams setParameter(String name, Object value) {
        return this.delegate.setParameter(name, value);
    }

    @Deprecated
    public HttpParams copy() {
        return this.delegate.copy();
    }

    public boolean removeParameter(String name) {
        return this.delegate.removeParameter(name);
    }

    public HttpParams setLongParameter(String name, long value) {
        return this.delegate.setLongParameter(name, value);
    }

    public HttpParams setIntParameter(String name, int value) {
        return this.delegate.setIntParameter(name, value);
    }

    public HttpParams setDoubleParameter(String name, double value) {
        return this.delegate.setDoubleParameter(name, value);
    }

    public HttpParams setBooleanParameter(String name, boolean value) {
        return this.delegate.setBooleanParameter(name, value);
    }

    public Object getParameter(String name) {
        return this.delegate.getParameter(name);
    }

    private <T> T getTypedParameter(String name, T defaultValue, Class<T> type, Function<Object, T> parser) {
        Object value = this.delegate.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        Class<?> valueType = value.getClass();
        if (type.isAssignableFrom(valueType)) {
            return type.cast(value);
        }
        try {
            return (T)parser.apply(value);
        }
        catch (Exception e) {
            ClassCastException cce = new ClassCastException("Cannot convert '" + value + "' of type " + valueType.getName() + " to " + type.getName());
            cce.initCause(e);
            throw cce;
        }
    }

    public long getLongParameter(final String name, long defaultValue) {
        return this.getTypedParameter(name, defaultValue, Long.TYPE, new Function<Object, Long>(){

            public Long apply(Object value) {
                Long longValue = Long.valueOf(value.toString());
                HttpParamsBean.this.delegate.setLongParameter(name, longValue.longValue());
                return longValue;
            }
        });
    }

    public int getIntParameter(final String name, int defaultValue) {
        return this.getTypedParameter(name, defaultValue, Integer.TYPE, new Function<Object, Integer>(){

            public Integer apply(Object value) {
                Integer intValue = Integer.valueOf(value.toString());
                HttpParamsBean.this.delegate.setIntParameter(name, intValue.intValue());
                return intValue;
            }
        });
    }

    public double getDoubleParameter(final String name, double defaultValue) {
        return this.getTypedParameter(name, defaultValue, Double.TYPE, new Function<Object, Double>(){

            public Double apply(Object value) {
                Double doubleValue = Double.valueOf(value.toString());
                HttpParamsBean.this.delegate.setDoubleParameter(name, doubleValue.doubleValue());
                return doubleValue;
            }
        });
    }

    public boolean getBooleanParameter(final String name, boolean defaultValue) {
        return this.getTypedParameter(name, defaultValue, Boolean.TYPE, new Function<Object, Boolean>(){

            public Boolean apply(Object value) {
                Boolean booleanValue = Boolean.valueOf(value.toString());
                HttpParamsBean.this.delegate.setBooleanParameter(name, booleanValue.booleanValue());
                return booleanValue;
            }
        });
    }

    public boolean isParameterTrue(String name) {
        return this.getBooleanParameter(name, false);
    }

    public boolean isParameterFalse(String name) {
        return !this.getBooleanParameter(name, false);
    }
}

