/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.InputFormatException;
import org.jasig.schedassist.model.MeetingDurations;

public final class AvailableBlockBuilder {
    protected static final String TIME_REGEX = "(\\d{1,2})\\:([0-5]\\d{1}) ([AP]M)";
    protected static final Pattern TIME_PATTERN = Pattern.compile("(\\d{1,2})\\:([0-5]\\d{1}) ([AP]M)", 2);
    protected static final int MINIMUM_MINUTES = 5;
    private static Log LOG = LogFactory.getLog(AvailableBlockBuilder.class);

    public static SortedSet<AvailableBlock> createBlocks(String startTimePhrase, String endTimePhrase, String daysOfWeekPhrase, Date startDate, Date endDate) throws InputFormatException {
        return AvailableBlockBuilder.createBlocks(startTimePhrase, endTimePhrase, daysOfWeekPhrase, startDate, endDate, 1);
    }

    public static SortedSet<AvailableBlock> createBlocks(String startTimePhrase, String endTimePhrase, String daysOfWeekPhrase, Date startDate, Date endDate, int visitorLimit) throws InputFormatException {
        return AvailableBlockBuilder.createBlocks(startTimePhrase, endTimePhrase, daysOfWeekPhrase, startDate, endDate, visitorLimit, null);
    }

    public static SortedSet<AvailableBlock> createBlocks(String startTimePhrase, String endTimePhrase, String daysOfWeekPhrase, Date startDate, Date endDate, int visitorLimit, String meetingLocation) throws InputFormatException {
        TreeSet<AvailableBlock> blocks = new TreeSet<AvailableBlock>();
        Date realStartDate = DateUtils.truncate((Date)startDate, (int)5);
        Date dayAfterEndDate = DateUtils.truncate((Date)DateUtils.addDays((Date)endDate, (int)1), (int)5);
        Date realEndDate = DateUtils.addSeconds((Date)dayAfterEndDate, (int)-1);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createBlocks calculated realStartDate: " + realStartDate + ", realEndDate: " + realEndDate));
        }
        List<Date> matchingDays = AvailableBlockBuilder.matchingDays(daysOfWeekPhrase, realStartDate, realEndDate);
        for (Date matchingDate : matchingDays) {
            Calendar startCalendar = Calendar.getInstance();
            startCalendar.setTime(matchingDate);
            Calendar endCalendar = (Calendar)startCalendar.clone();
            AvailableBlockBuilder.interpretAndUpdateTime(startTimePhrase, startCalendar);
            AvailableBlockBuilder.interpretAndUpdateTime(endTimePhrase, endCalendar);
            Date blockStartTime = startCalendar.getTime();
            Date blockEndTime = endCalendar.getTime();
            if (!blockEndTime.after(blockStartTime)) {
                throw new InputFormatException("Start time must occur before end time");
            }
            if (!CommonDateOperations.equalsOrAfter(blockStartTime, realStartDate) || !CommonDateOperations.equalsOrBefore(blockEndTime, realEndDate)) continue;
            AvailableBlock block = new AvailableBlock(blockStartTime, blockEndTime, visitorLimit, meetingLocation);
            blocks.add(block);
        }
        return blocks;
    }

    public static AvailableBlock createBlock(Date startDate, Date endDate) {
        return AvailableBlockBuilder.createBlock(startDate, endDate, 1);
    }

    public static AvailableBlock createBlock(Date startDate, Date endDate, int visitorLimit) {
        return AvailableBlockBuilder.createBlock(startDate, endDate, visitorLimit, null);
    }

    public static AvailableBlock createBlock(Date startDate, Date endDate, int visitorLimit, String meetingLocation) {
        return new AvailableBlock(startDate, endDate, visitorLimit, meetingLocation);
    }

    public static AvailableBlock createBlock(String startTimePhrase, String endTimePhrase) throws InputFormatException {
        return AvailableBlockBuilder.createBlock(startTimePhrase, endTimePhrase, 1);
    }

    public static AvailableBlock createBlock(String startTimePhrase, String endTimePhrase, int visitorLimit) throws InputFormatException {
        return AvailableBlockBuilder.createBlock(startTimePhrase, endTimePhrase, visitorLimit, null);
    }

    public static AvailableBlock createBlock(String startTimePhrase, String endTimePhrase, int visitorLimit, String meetingLocation) throws InputFormatException {
        Date startTime = CommonDateOperations.parseDateTimePhrase(startTimePhrase);
        Date endTime = CommonDateOperations.parseDateTimePhrase(endTimePhrase);
        return AvailableBlockBuilder.createBlock(startTime, endTime, visitorLimit, meetingLocation);
    }

    public static AvailableBlock createBlock(String startTimePhrase, int duration) throws InputFormatException {
        Date startTime = CommonDateOperations.parseDateTimePhrase(startTimePhrase);
        Date endTime = DateUtils.addMinutes((Date)startTime, (int)duration);
        return AvailableBlockBuilder.createBlock(startTime, endTime);
    }

    public static AvailableBlock createBlockEndsAt(Date endDate, int duration) {
        Date startDate = DateUtils.addMinutes((Date)endDate, (int)(-duration));
        return AvailableBlockBuilder.createBlock(startDate, endDate);
    }

    public static AvailableBlock createPreferredMinimumDurationBlock(Date startTime, MeetingDurations preferredMeetingDurations) {
        return AvailableBlockBuilder.createPreferredMinimumDurationBlock(startTime, preferredMeetingDurations, 1);
    }

    public static AvailableBlock createPreferredMinimumDurationBlock(Date startTime, MeetingDurations preferredMeetingDurations, int visitorLimit) {
        Date endTime = DateUtils.addMinutes((Date)startTime, (int)preferredMeetingDurations.getMinLength());
        return AvailableBlockBuilder.createBlock(startTime, endTime, visitorLimit);
    }

    public static AvailableBlock createSmallestAllowedBlock(String startTimePhrase) throws InputFormatException {
        return AvailableBlockBuilder.createSmallestAllowedBlock(startTimePhrase, 1);
    }

    public static AvailableBlock createSmallestAllowedBlock(String startTimePhrase, int visitorLimit) throws InputFormatException {
        Date startTime = CommonDateOperations.parseDateTimePhrase(startTimePhrase);
        return AvailableBlockBuilder.createSmallestAllowedBlock(startTime, visitorLimit);
    }

    public static AvailableBlock createSmallestAllowedBlock(Date startTime) {
        return AvailableBlockBuilder.createSmallestAllowedBlock(startTime, 1);
    }

    public static AvailableBlock createSmallestAllowedBlock(Date startTime, int visitorLimit) {
        Date endTime = DateUtils.addMinutes((Date)startTime, (int)5);
        return AvailableBlockBuilder.createBlock(startTime, endTime, visitorLimit);
    }

    public static AvailableBlock createMinimumEndBlock(Date endTime) {
        Date startTime = DateUtils.addMinutes((Date)endTime, (int)-5);
        return AvailableBlockBuilder.createBlock(startTime, endTime);
    }

    public static SortedSet<AvailableBlock> expand(AvailableBlock largeBlock, int meetingLengthMinutes) {
        TreeSet<AvailableBlock> smallBlocks = new TreeSet<AvailableBlock>();
        long meetingLengthInMsec = AvailableBlockBuilder.convertMinutesToMsec(meetingLengthMinutes);
        Date currentStart = largeBlock.getStartTime();
        while (largeBlock.getEndTime().getTime() - currentStart.getTime() >= meetingLengthInMsec) {
            Date newEndTime = new Date(currentStart.getTime() + meetingLengthInMsec);
            AvailableBlock smallBlock = AvailableBlockBuilder.createBlock(currentStart, newEndTime, largeBlock.getVisitorLimit(), largeBlock.getMeetingLocation());
            smallBlock.setVisitorsAttending(largeBlock.getVisitorsAttending());
            smallBlocks.add(smallBlock);
            currentStart = newEndTime;
        }
        return smallBlocks;
    }

    public static SortedSet<AvailableBlock> expand(Set<AvailableBlock> largeBlocks, int meetingLengthMinutes) {
        TreeSet<AvailableBlock> smallBlocks = new TreeSet<AvailableBlock>();
        for (AvailableBlock sourceBlock : largeBlocks) {
            smallBlocks.addAll(AvailableBlockBuilder.expand(sourceBlock, meetingLengthMinutes));
        }
        return smallBlocks;
    }

    public static SortedSet<AvailableBlock> combine(SortedSet<AvailableBlock> smallBlocks) {
        TreeSet<AvailableBlock> largeBlocks = new TreeSet<AvailableBlock>();
        Iterator smallBlockIterator = smallBlocks.iterator();
        if (smallBlockIterator.hasNext()) {
            AvailableBlock current = (AvailableBlock)smallBlockIterator.next();
            while (smallBlockIterator.hasNext()) {
                AvailableBlock next = (AvailableBlock)smallBlockIterator.next();
                if (AvailableBlockBuilder.combinable(current, next)) {
                    try {
                        current = new AvailableBlock(current.getStartTime(), next.getEndTime(), current.getVisitorLimit(), current.getMeetingLocation());
                    }
                    catch (IllegalArgumentException e) {
                        LOG.error((Object)("failed to create an AvailableBlock from " + current.getStartTime() + " and " + next.getEndTime()), (Throwable)e);
                    }
                    continue;
                }
                largeBlocks.add(current);
                current = next;
            }
            largeBlocks.add(current);
        }
        return largeBlocks;
    }

    static boolean combinable(AvailableBlock left, AvailableBlock right) {
        if (left == null || right == null) {
            return false;
        }
        return left.getEndTime().equals(right.getStartTime()) && left.getVisitorLimit() == right.getVisitorLimit() && AvailableBlockBuilder.safeMeetingLocationEquals(left, right);
    }

    static boolean safeMeetingLocationEquals(AvailableBlock left, AvailableBlock right) {
        String leftLocation = left.getMeetingLocation();
        String rightLocation = right.getMeetingLocation();
        if (leftLocation == null && rightLocation == null) {
            return true;
        }
        if (leftLocation != null) {
            return leftLocation.equals(rightLocation);
        }
        if (rightLocation != null) {
            return rightLocation.equals(leftLocation);
        }
        return false;
    }

    protected static List<Date> matchingDays(String daysOfWeekPhrase, Date startDate, Date endDate) {
        ArrayList<Date> matchingDays = new ArrayList<Date>();
        HashSet<Integer> daysOfWeek = new HashSet<Integer>();
        block9: for (char character : daysOfWeekPhrase.toUpperCase().toCharArray()) {
            switch (character) {
                case 'N': {
                    daysOfWeek.add(1);
                    continue block9;
                }
                case 'M': {
                    daysOfWeek.add(2);
                    continue block9;
                }
                case 'T': {
                    daysOfWeek.add(3);
                    continue block9;
                }
                case 'W': {
                    daysOfWeek.add(4);
                    continue block9;
                }
                case 'R': {
                    daysOfWeek.add(5);
                    continue block9;
                }
                case 'F': {
                    daysOfWeek.add(6);
                    continue block9;
                }
                case 'S': {
                    daysOfWeek.add(7);
                }
            }
        }
        Calendar current = Calendar.getInstance();
        current.setTime(startDate);
        current = CommonDateOperations.zeroOutTimeFields(current);
        while (current.getTime().compareTo(endDate) < 0) {
            if (daysOfWeek.contains(current.get(7))) {
                matchingDays.add(current.getTime());
            }
            current.add(5, 1);
        }
        return matchingDays;
    }

    protected static void interpretAndUpdateTime(String timePhrase, Calendar toModify) throws InputFormatException {
        int endMinutes;
        int endHour;
        Matcher matcher = TIME_PATTERN.matcher(timePhrase);
        if (matcher.matches()) {
            endHour = Integer.parseInt(matcher.group(1));
            endMinutes = Integer.parseInt(matcher.group(2));
            if (endHour == 12 && matcher.group(3).equalsIgnoreCase("am")) {
                endHour = 0;
            }
            if (matcher.group(3).equalsIgnoreCase("pm") && endHour != 12) {
                endHour += 12;
            }
        } else {
            throw new InputFormatException(timePhrase + " does not match expected format of HH:MM AM/PM");
        }
        toModify.set(11, endHour);
        toModify.set(12, endMinutes);
    }

    protected static long convertMinutesToMsec(int minutes) {
        long msecPerSecond = 1000L;
        long secondsPerMinute = 60L;
        long result = (long)minutes * 60L * 1000L;
        return result;
    }
}

