/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.model;

import java.util.Map;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.MeetingDurations;
import org.jasig.schedassist.model.Preferences;
import org.jasig.schedassist.model.Reminders;
import org.jasig.schedassist.model.VisibleWindow;

public abstract class AbstractScheduleOwner
implements IScheduleOwner {
    private static final long serialVersionUID = 1L;
    private final ICalendarAccount calendarAccount;

    public AbstractScheduleOwner(ICalendarAccount calendarAccount) {
        this.calendarAccount = calendarAccount;
    }

    @Override
    public abstract long getId();

    @Override
    public abstract String getPreference(Preferences var1);

    @Override
    public abstract Map<Preferences, String> getPreferences();

    @Override
    public ICalendarAccount getCalendarAccount() {
        return this.calendarAccount;
    }

    @Override
    public final String getPreferredLocation() {
        return this.getPreferences().get((Object)Preferences.LOCATION);
    }

    @Override
    public final Reminders getRemindersPreference() {
        String emailPreferencesValue = this.getPreferences().get((Object)Preferences.REMINDERS);
        Reminders result = Reminders.fromKey(emailPreferencesValue);
        return result;
    }

    @Override
    public final MeetingDurations getPreferredMeetingDurations() {
        String meetingDurationsValue = this.getPreferences().get((Object)Preferences.DURATIONS);
        MeetingDurations result = MeetingDurations.fromKey(meetingDurationsValue);
        return result;
    }

    @Override
    public final VisibleWindow getPreferredVisibleWindow() {
        String visibleWindowValue = this.getPreferences().get((Object)Preferences.VISIBLE_WINDOW);
        VisibleWindow result = VisibleWindow.fromKey(visibleWindowValue);
        return result;
    }

    @Override
    public final int getPreferredMinimumDuration() {
        MeetingDurations preferredDurations = this.getPreferredMeetingDurations();
        return preferredDurations.getMinLength();
    }

    @Override
    public final boolean isSamePerson(IScheduleVisitor visitor) {
        if (null == visitor) {
            return false;
        }
        return this.calendarAccount.equals(visitor.getCalendarAccount());
    }

    @Override
    public final boolean hasMeetingLimit() {
        String prefValue = this.getPreference(Preferences.MEETING_LIMIT);
        int limit = Integer.parseInt(prefValue);
        return limit > 0;
    }

    @Override
    public final boolean isExceedingMeetingLimit(int visibleScheduleAttendingCount) {
        String prefValue = this.getPreference(Preferences.MEETING_LIMIT);
        int limit = Integer.parseInt(prefValue);
        if (limit == -1) {
            return false;
        }
        return visibleScheduleAttendingCount >= limit;
    }

    @Override
    public final int getPreferredDefaultVisitorLimit() {
        String prefValue = this.getPreference(Preferences.DEFAULT_VISITOR_LIMIT);
        int limit = Integer.parseInt(prefValue);
        return limit;
    }

    @Override
    public final boolean isReflectSchedule() {
        String prefValue = this.getPreference(Preferences.REFLECT_SCHEDULE);
        boolean result = Boolean.parseBoolean(prefValue);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.calendarAccount == null ? 0 : this.calendarAccount.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractScheduleOwner other = (AbstractScheduleOwner)obj;
        return !(this.calendarAccount == null ? other.calendarAccount != null : !this.calendarAccount.equals(other.calendarAccount));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AbstractScheduleOwner [calendarAccount=");
        builder.append(this.calendarAccount);
        builder.append("]");
        return builder.toString();
    }
}

