/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.jasig.schedassist.model.InputFormatException;

public final class CommonDateOperations {
    private static final long MILLISECS_PER_DAY = 86400000L;
    protected static final String DATE_TIME_FORMAT = "yyyyMMdd-HHmm";
    protected static final String DATE_FORMAT = "yyyyMMdd";

    public static SimpleDateFormat getDateTimeFormat() {
        return new SimpleDateFormat(DATE_TIME_FORMAT);
    }

    public static SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat(DATE_FORMAT);
    }

    public static Date calculateSundayPrior(Date date) {
        Calendar weekOfCal = Calendar.getInstance();
        weekOfCal.setTime(date);
        weekOfCal = DateUtils.truncate((Calendar)weekOfCal, (int)5);
        int dayOfWeek = weekOfCal.get(7);
        int differenceToSunday = dayOfWeek % 7 - 1;
        weekOfCal.add(5, -differenceToSunday);
        return weekOfCal.getTime();
    }

    public static Date parseDateTimePhrase(String timePhrase) throws InputFormatException {
        try {
            Date time = CommonDateOperations.getDateTimeFormat().parse(timePhrase);
            time = DateUtils.truncate((Date)time, (int)12);
            return time;
        }
        catch (ParseException e) {
            throw new InputFormatException("cannot parse date/time phrase " + timePhrase, e);
        }
    }

    public static Date parseDatePhrase(String datePhrase) throws InputFormatException {
        try {
            Date date = CommonDateOperations.getDateFormat().parse(datePhrase);
            date = DateUtils.truncate((Date)date, (int)5);
            return date;
        }
        catch (ParseException e) {
            throw new InputFormatException("cannot parse date phrase " + datePhrase, e);
        }
    }

    public static boolean equalsOrAfter(Date date1, Date date2) {
        return DateUtils.isSameInstant((Date)date1, (Date)date2) || date1.after(date2);
    }

    public static boolean equalsOrBefore(Date date1, Date date2) {
        return DateUtils.isSameInstant((Date)date1, (Date)date2) || date1.before(date2);
    }

    public static long approximateDifference(Date start, Date end) {
        Calendar s = Calendar.getInstance();
        s.setTime(start);
        Calendar e = Calendar.getInstance();
        e.setTime(end);
        long endL = e.getTimeInMillis() + (long)e.getTimeZone().getOffset(e.getTimeInMillis());
        long startL = s.getTimeInMillis() + (long)s.getTimeZone().getOffset(s.getTimeInMillis());
        return (endL - startL) / 86400000L;
    }

    public static int numberOfDaysUntilSunday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayOfWeek = cal.get(7);
        int result = 7;
        switch (dayOfWeek) {
            case 1: {
                result = 7;
                break;
            }
            case 2: {
                result = 6;
                break;
            }
            case 3: {
                result = 5;
                break;
            }
            case 4: {
                result = 4;
                break;
            }
            case 5: {
                result = 3;
                break;
            }
            case 6: {
                result = 2;
                break;
            }
            case 7: {
                result = 1;
            }
        }
        return result;
    }

    protected static Calendar zeroOutTimeFields(Calendar calendar) {
        return DateUtils.truncate((Calendar)calendar, (int)5);
    }

    public static Date beginningOfDay(Date date) {
        return DateUtils.truncate((Date)date, (int)5);
    }

    public static Date endOfDay(Date date) {
        Date local = CommonDateOperations.beginningOfDay(date);
        local = DateUtils.addDays((Date)local, (int)1);
        local = DateUtils.addMilliseconds((Date)local, (int)-1);
        return local;
    }
}

