/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.model;

import java.io.Serializable;

public final class MeetingDurations
implements Serializable {
    private static final long serialVersionUID = -8057215291650880899L;
    public static final MeetingDurations FIFTEEN = new MeetingDurations("15", 15, 15);
    public static final MeetingDurations THIRTY = new MeetingDurations("30", 30, 30);
    public static final MeetingDurations THIRTY_SIXTY = new MeetingDurations("30,60", 30, 60);
    public static final MeetingDurations FORTYFIVE = new MeetingDurations("45", 45, 45);
    private String key;
    private int minLength;
    private int maxLength;

    MeetingDurations(String key, int minLength, int maxLength) {
        this.key = key;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public String getKey() {
        return this.key;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean isDoubleLength() {
        return this.maxLength == 2 * this.minLength;
    }

    public static MeetingDurations fromKey(String key) {
        try {
            int minValue;
            String[] tokens = key.split(",");
            int maxValue = minValue = Integer.parseInt(tokens[0]);
            if (tokens.length == 2) {
                maxValue = Integer.parseInt(tokens[1]);
            }
            MeetingDurations durations = new MeetingDurations(key, minValue, maxValue);
            return durations;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("could not convert key to an integer " + key, e);
        }
    }
}

