/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.model;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.VisibleWindow;

public class VisibleScheduleRequestConstraints
implements Serializable {
    private static final long serialVersionUID = -2213895500433357816L;
    public static final int WEEKS_PER_PAGE = 4;
    private static Log LOG = LogFactory.getLog(VisibleScheduleRequestConstraints.class);
    private final Date targetStartDate;
    private final Date targetEndDate;
    private final Integer nextWeekIndex;
    private final Integer prevWeekIndex;
    private final int constrainedWeekStart;

    private VisibleScheduleRequestConstraints(Date targetStartDate, Date targetEndDate, Integer nextWeekIndex, Integer prevWeekIndex, int constrainedWeekStart) {
        this.targetStartDate = targetStartDate;
        this.targetEndDate = targetEndDate;
        this.nextWeekIndex = nextWeekIndex;
        this.prevWeekIndex = prevWeekIndex;
        this.constrainedWeekStart = constrainedWeekStart;
    }

    public Date getTargetStartDate() {
        return this.targetStartDate;
    }

    public Date getTargetEndDate() {
        return this.targetEndDate;
    }

    public Integer getNextWeekIndex() {
        return this.nextWeekIndex;
    }

    public Integer getPrevWeekIndex() {
        return this.prevWeekIndex;
    }

    public int getConstrainedWeekStart() {
        return this.constrainedWeekStart;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VisibleScheduleDisplayRequestDetails [targetStartDate=");
        builder.append(this.targetStartDate);
        builder.append(", targetEndDate=");
        builder.append(this.targetEndDate);
        builder.append(", nextWeekIndex=");
        builder.append(this.nextWeekIndex);
        builder.append(", prevWeekIndex=");
        builder.append(this.prevWeekIndex);
        builder.append(", constrainedWeekStart=");
        builder.append(this.constrainedWeekStart);
        builder.append("]");
        return builder.toString();
    }

    public static VisibleScheduleRequestConstraints newInstance(IScheduleOwner owner, int weekStart) {
        VisibleWindow window = owner.getPreferredVisibleWindow();
        int constrainedWeekStart = VisibleScheduleRequestConstraints.constrainWeekStartToWindow(window, weekStart);
        Integer nextWeekIndex = VisibleScheduleRequestConstraints.calculateNextWeekIndex(window, constrainedWeekStart);
        Integer prevWeekIndex = VisibleScheduleRequestConstraints.calculatePrevWeekIndex(window, constrainedWeekStart);
        Date targetStartDate = VisibleScheduleRequestConstraints.resolveStartDate(new Date(), constrainedWeekStart);
        Date targetEndDate = VisibleScheduleRequestConstraints.resolveEndDate(window, targetStartDate);
        VisibleScheduleRequestConstraints result = new VisibleScheduleRequestConstraints(targetStartDate, targetEndDate, nextWeekIndex, prevWeekIndex, constrainedWeekStart);
        return result;
    }

    protected static int constrainWeekStartToWindow(VisibleWindow window, int weekStart) {
        if (weekStart < 1) {
            return 0;
        }
        if (weekStart > window.getWindowWeeksEnd()) {
            return window.getWindowWeeksEnd();
        }
        return weekStart;
    }

    protected static Integer calculateNextWeekIndex(VisibleWindow window, int weekStart) {
        if (weekStart < 1) {
            weekStart = 0;
        }
        int maxPreferredWeekStart = window.getWindowWeeksEnd();
        Integer result = null;
        if (window.getWindowWeeksEnd() > 4 && weekStart < maxPreferredWeekStart && (result = Integer.valueOf(weekStart + 4)) > maxPreferredWeekStart) {
            result = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("calculateNextWeekStart for " + window + ", weekStart=" + weekStart + " returns " + result));
        }
        return result;
    }

    protected static Integer calculatePrevWeekIndex(VisibleWindow window, int weekStart) {
        Integer result = null;
        if (weekStart > 0 && window.getWindowWeeksEnd() > 4 && weekStart < window.getWindowWeeksEnd()) {
            result = weekStart - 4 < 1 ? 0 : weekStart - 4;
        } else if (weekStart == window.getWindowWeeksEnd() && window.getWindowWeeksEnd() > 4) {
            result = weekStart - 4;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("calculatePrevWeekStart for " + window + ", weekStart=" + weekStart + " returns " + result));
        }
        return result;
    }

    protected static Date resolveStartDate(Date referencePoint, int weekStart) {
        Date start = referencePoint;
        if (weekStart > 0) {
            start = DateUtils.addDays((Date)start, (int)CommonDateOperations.numberOfDaysUntilSunday(start));
            start = DateUtils.addWeeks((Date)start, (int)(weekStart - 1));
        }
        return start;
    }

    protected static Date resolveEndDate(VisibleWindow window, Date start) {
        Date preferredEnd = DateUtils.addWeeks((Date)start, (int)window.getWindowWeeksEnd());
        Date end = DateUtils.addWeeks((Date)start, (int)4);
        if (end.after(preferredEnd)) {
            return preferredEnd;
        }
        return end;
    }
}

