/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.model;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.UUID;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.PropertyFactoryImpl;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.parameter.Rsvp;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.IAffiliationSource;
import org.jasig.schedassist.model.AppointmentRole;
import org.jasig.schedassist.model.AvailabilityReflection;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.AvailableBlockBuilder;
import org.jasig.schedassist.model.AvailableSchedule;
import org.jasig.schedassist.model.AvailableVersion;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IEventUtils;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.Preferences;
import org.jasig.schedassist.model.SchedulingAssistantAppointment;
import org.jasig.schedassist.model.VisitorLimit;

public class DefaultEventUtilsImpl
implements IEventUtils {
    public static final String ICAL_DATETIME_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    public static final ProdId PROD_ID = new ProdId("-//jasig.org//Jasig Scheduling Assistant 1.0//EN");
    private static final FastDateFormat FASTDATEFORMAT = FastDateFormat.getInstance((String)"yyyyMMdd'T'HHmmss'Z'", (TimeZone)TimeZone.getTimeZone("UTC"));
    protected final Log LOG = LogFactory.getLog(this.getClass());
    private final IAffiliationSource affiliationSource;

    public DefaultEventUtilsImpl(IAffiliationSource affiliationSource) {
        this.affiliationSource = affiliationSource;
    }

    public IAffiliationSource getAffiliationSource() {
        return this.affiliationSource;
    }

    @Override
    public boolean attendeeMatchesPerson(Property attendee, ICalendarAccount calendarAccount) {
        if (null == attendee || !"ATTENDEE".equals(attendee.getName())) {
            return false;
        }
        Cn cn = (Cn)attendee.getParameter("CN");
        if (null == cn) {
            return false;
        }
        boolean cnResult = cn.getValue().equals(calendarAccount.getDisplayName());
        URI mailTo = DefaultEventUtilsImpl.emailToURI(calendarAccount.getEmailAddress());
        boolean mailResult = attendee.getValue().equals(mailTo.toString());
        return cnResult && mailResult;
    }

    @Override
    public VEvent constructAvailableAppointment(AvailableBlock block, IScheduleOwner owner, IScheduleVisitor visitor, String eventDescription) {
        Validate.notNull((Object)block, (String)"available block cannot be null");
        Validate.notNull((Object)owner, (String)"schedule owner cannot be null");
        Validate.notNull((Object)visitor, (String)"schedule visitor cannot be null");
        try {
            VEvent event = new VEvent();
            event.getProperties().add((Property)new DtStart((Date)new DateTime(DefaultEventUtilsImpl.convertToICalendarFormat(block.getStartTime()))));
            event.getProperties().add((Property)new DtEnd((Date)new DateTime(DefaultEventUtilsImpl.convertToICalendarFormat(block.getEndTime()))));
            if (owner.isSamePerson(visitor)) {
                Attendee singleAttendee = this.constructAvailableAttendee(visitor.getCalendarAccount(), AppointmentRole.BOTH);
                event.getProperties().add((Property)singleAttendee);
            } else {
                Attendee visitorAttendee = this.constructAvailableAttendee(visitor.getCalendarAccount(), AppointmentRole.VISITOR);
                event.getProperties().add((Property)visitorAttendee);
                Attendee ownerAttendee = this.constructAvailableAttendee(owner.getCalendarAccount(), AppointmentRole.OWNER);
                event.getProperties().add((Property)ownerAttendee);
            }
            event.getProperties().add((Property)SchedulingAssistantAppointment.TRUE);
            event.getProperties().add((Property)AvailableVersion.AVAILABLE_VERSION_1_2);
            event.getProperties().add((Property)new VisitorLimit(block.getVisitorLimit()));
            StringBuilder title = new StringBuilder();
            title.append(owner.getPreference(Preferences.MEETING_PREFIX));
            if (block.getVisitorLimit() == 1) {
                title.append(" with ");
                title.append(visitor.getCalendarAccount().getDisplayName());
                Description description = new Description(eventDescription);
                event.getProperties().add((Property)description);
            }
            event.getProperties().add((Property)new Summary(title.toString()));
            event.getProperties().add((Property)Clazz.PRIVATE);
            String blockMeetingLocationOverride = block.getMeetingLocation();
            if (StringUtils.isNotBlank((String)blockMeetingLocationOverride)) {
                event.getProperties().add((Property)new Location(blockMeetingLocationOverride));
            } else {
                String preferredLocation = owner.getPreferredLocation();
                if (StringUtils.isNotBlank((String)preferredLocation)) {
                    event.getProperties().add((Property)new Location(preferredLocation));
                }
            }
            event.getProperties().add((Property)Status.VEVENT_CONFIRMED);
            return event;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("caught ParseException creating event", e);
        }
    }

    @Override
    public Attendee constructAvailableAttendee(ICalendarAccount calendarAccount, AppointmentRole role) {
        ParameterList parameterList = new ParameterList();
        parameterList.add((Parameter)PartStat.ACCEPTED);
        parameterList.add((Parameter)CuType.INDIVIDUAL);
        parameterList.add((Parameter)Rsvp.FALSE);
        parameterList.add((Parameter)role);
        parameterList.add((Parameter)new Cn(calendarAccount.getDisplayName()));
        Attendee attendee = new Attendee(parameterList, DefaultEventUtilsImpl.emailToURI(calendarAccount.getEmailAddress()));
        return attendee;
    }

    @Override
    public Property getAttendeeForUserFromEvent(VEvent event, ICalendarAccount calendarUser) {
        if (null == event || null == calendarUser) {
            return null;
        }
        PropertyList propertyList = this.getAttendeeListFromEvent(event);
        for (Object o : propertyList) {
            Property attendee = (Property)o;
            if (!this.attendeeMatchesPerson(attendee, calendarUser)) continue;
            return attendee;
        }
        return null;
    }

    @Override
    public PropertyList getAttendeeListFromEvent(VEvent event) {
        if (null == event) {
            return new PropertyList();
        }
        PropertyList attendees = event.getProperties("ATTENDEE");
        return attendees;
    }

    @Override
    public int getScheduleVisitorCount(VEvent event) {
        if (null == event) {
            return 0;
        }
        PropertyList propertyList = event.getProperties("ATTENDEE");
        int count = 0;
        for (Object o : propertyList) {
            Attendee attendee = (Attendee)o;
            Parameter role = attendee.getParameter("X-UW-AVAILABLE-APPOINTMENT-ROLE");
            if (null == role || !AppointmentRole.VISITOR.equals(role)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean willEventCauseConflict(ICalendarAccount calendarAccount, VEvent event) {
        Property ownerAttendee = this.getAttendeeForUserFromEvent(event, calendarAccount);
        if (ownerAttendee != null) {
            Parameter p = ownerAttendee.getParameter("PARTSTAT");
            return PartStat.ACCEPTED.equals((Object)p);
        }
        return false;
    }

    @Override
    public boolean isAttendingMatch(VEvent event, IScheduleVisitor visitor, IScheduleOwner owner) {
        if (event.getProperties().contains((Object)SchedulingAssistantAppointment.TRUE)) {
            boolean visitorIsVisitor = false;
            boolean ownerIsOwner = false;
            PropertyList attendees = this.getAttendeeListFromEvent(event);
            for (Object obj : attendees) {
                Property attendee = (Property)obj;
                Parameter p = attendee.getParameter("X-UW-AVAILABLE-APPOINTMENT-ROLE");
                if (null != p) {
                    AppointmentRole role = new AppointmentRole(p.getValue());
                    if (role.isBoth() && owner.isSamePerson(visitor) && this.attendeeMatchesPerson(attendee, visitor.getCalendarAccount())) {
                        return true;
                    }
                    if (role.isVisitor()) {
                        if (this.attendeeMatchesPerson(attendee, visitor.getCalendarAccount())) {
                            visitorIsVisitor = true;
                        }
                    } else if (role.isOwner() && this.attendeeMatchesPerson(attendee, owner.getCalendarAccount())) {
                        ownerIsOwner = true;
                    }
                } else if (this.attendeeMatchesPerson(attendee, visitor.getCalendarAccount())) {
                    visitorIsVisitor = true;
                } else if (this.attendeeMatchesPerson(attendee, owner.getCalendarAccount())) {
                    ownerIsOwner = true;
                }
                if (!visitorIsVisitor || !ownerIsOwner) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAttendingAsVisitor(VEvent event, ICalendarAccount proposedVisitor) {
        if (event.getProperties().contains((Object)SchedulingAssistantAppointment.TRUE)) {
            PropertyList attendees = this.getAttendeeListFromEvent(event);
            for (Object obj : attendees) {
                AppointmentRole role;
                Property attendee = (Property)obj;
                Parameter p = attendee.getParameter("X-UW-AVAILABLE-APPOINTMENT-ROLE");
                if (null == p || !(role = new AppointmentRole(p.getValue())).isVisitor() || !this.attendeeMatchesPerson(attendee, proposedVisitor)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAttendingAsOwner(VEvent event, ICalendarAccount proposedOwner) {
        if (event.getProperties().contains((Object)SchedulingAssistantAppointment.TRUE)) {
            PropertyList attendees = this.getAttendeeListFromEvent(event);
            for (Object obj : attendees) {
                AppointmentRole role;
                Property attendee = (Property)obj;
                Parameter p = attendee.getParameter("X-UW-AVAILABLE-APPOINTMENT-ROLE");
                if (null == p || !(role = new AppointmentRole(p.getValue())).isOwner() || !this.attendeeMatchesPerson(attendee, proposedOwner)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Calendar> convertScheduleForReflection(AvailableSchedule availableSchedule) {
        if (availableSchedule.isEmpty()) {
            return Collections.emptyList();
        }
        SortedSet<AvailableBlock> combinedBlocks = AvailableBlockBuilder.combine(availableSchedule.getAvailableBlocks());
        HashMap<String, VEvent> summaryToEvent = new HashMap<String, VEvent>();
        for (AvailableBlock block : combinedBlocks) {
            String summary = this.constructSummaryValueForReflectionEvent(block);
            VEvent event = (VEvent)summaryToEvent.get(summary);
            if (event == null) {
                event = this.convertBlockToReflectionEvent(block);
                summaryToEvent.put(summary, event);
                continue;
            }
            Date start = new Date(DateUtils.truncate((java.util.Date)block.getStartTime(), (int)5));
            CustomRDate rDate = new CustomRDate(start.toString());
            event.getProperties().add((Property)rDate);
        }
        ArrayList<Calendar> results = new ArrayList<Calendar>();
        for (VEvent e : summaryToEvent.values()) {
            results.add(this.wrapEventInCalendar(e));
        }
        return results;
    }

    @Override
    public Calendar wrapEventInCalendar(VEvent event) {
        ComponentList components = new ComponentList();
        components.add((Component)event);
        Calendar result = new Calendar(components);
        result.getProperties().add((Property)Version.VERSION_2_0);
        result.getProperties().add((Property)PROD_ID);
        return result;
    }

    @Override
    public Uid generateNewUid() {
        UUID uuid = UUID.randomUUID();
        Uid result = new Uid(uuid.toString());
        return result;
    }

    protected VEvent convertBlockToReflectionEvent(AvailableBlock block) {
        java.util.Date blockStartTime = DateUtils.truncate((java.util.Date)block.getStartTime(), (int)5);
        DtStart start = new DtStart(new Date(blockStartTime));
        DtStamp stamp = new DtStamp(new DateTime(new java.util.Date()));
        java.util.Date blockEndTime = DateUtils.addDays((java.util.Date)blockStartTime, (int)1);
        DtEnd end = new DtEnd(new Date(blockEndTime));
        PropertyList properties = new PropertyList();
        properties.add((Property)new Summary(this.constructSummaryValueForReflectionEvent(block)));
        properties.add((Property)start);
        properties.add((Property)stamp);
        properties.add((Property)end);
        properties.add((Property)new Created(new DateTime(new java.util.Date())));
        properties.add((Property)new LastModified(new DateTime(new java.util.Date())));
        properties.add((Property)Clazz.PRIVATE);
        properties.add((Property)new Sequence(0));
        properties.add((Property)Transp.TRANSPARENT);
        if (StringUtils.isNotBlank((String)block.getMeetingLocation())) {
            properties.add((Property)new Location(block.getMeetingLocation()));
        }
        properties.add((Property)AvailabilityReflection.TRUE);
        VEvent event = new VEvent(properties);
        return event;
    }

    protected String constructSummaryValueForReflectionEvent(AvailableBlock block) {
        SimpleDateFormat df = new SimpleDateFormat("h:mm a");
        StringBuilder summary = new StringBuilder();
        summary.append("Available ");
        summary.append(df.format(block.getStartTime()));
        summary.append(" - ");
        summary.append(df.format(block.getEndTime()));
        return summary.toString();
    }

    public static String convertToICalendarFormat(java.util.Date date) {
        Validate.notNull((Object)date, (String)"cannot format null date");
        return FASTDATEFORMAT.format(DateUtils.truncate((java.util.Date)date, (int)13));
    }

    public static boolean isPartStatNeedsAction(Property attendee) {
        Validate.notNull((Object)attendee);
        Parameter p = attendee.getParameter("PARTSTAT");
        return PartStat.NEEDS_ACTION.equals((Object)p);
    }

    public static URI emailToURI(String emailAddress) {
        Validate.notEmpty((String)emailAddress, (String)"emailAddress cannot be null");
        try {
            return new URI("mailto:" + emailAddress);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("caught URISyntaxException trying to construct mailto URI for " + emailAddress, e);
        }
    }

    @Override
    public Integer getEventVisitorLimit(VEvent event) {
        if (event == null) {
            return null;
        }
        Property limit = event.getProperty("X-UW-AVAILABLE-VISITOR-LIMIT");
        if (limit != null) {
            return Integer.parseInt(limit.getValue());
        }
        return null;
    }

    static class CustomRDate
    extends Property {
        private static final long serialVersionUID = 1L;
        private static final ParameterList params = new ParameterList();
        private String value;

        public CustomRDate(String value) {
            super("RDATE", params, (PropertyFactory)PropertyFactoryImpl.getInstance());
            this.value = value;
        }

        public void setValue(String aValue) throws IOException, URISyntaxException, ParseException {
            this.value = aValue;
        }

        public void validate() throws ValidationException {
        }

        public String getValue() {
            return this.value;
        }

        static {
            params.add((Parameter)Value.DATE);
        }
    }
}

