/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.model;

import java.io.Serializable;
import org.jasig.schedassist.model.Preferences;

public class Reminders
implements Serializable {
    private static final long serialVersionUID = -7394013183165410327L;
    private final String key;
    private final boolean enabled;
    private final boolean includeOwner;
    private final int hours;
    public static final Reminders DEFAULT = Reminders.fromKey(Preferences.REMINDERS.getDefaultValue());

    Reminders(String key, boolean enabled, boolean includeOwner, int hours) {
        this.key = key;
        this.enabled = enabled;
        this.includeOwner = includeOwner;
        this.hours = hours;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isIncludeOwner() {
        return this.includeOwner;
    }

    public int getHours() {
        return this.hours;
    }

    public static Reminders fromKey(String keyValue) {
        try {
            String[] tokens = keyValue.split(",");
            if (tokens.length != 3) {
                throw new IllegalArgumentException("could not convert key to an EmailReminders " + keyValue);
            }
            boolean enabled = Boolean.parseBoolean(tokens[0]);
            boolean includeOwner = Boolean.parseBoolean(tokens[1]);
            int minutes = Integer.parseInt(tokens[2]);
            Reminders result = new Reminders(keyValue, enabled, includeOwner, minutes);
            return result;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("could not convert key to an EmailReminders " + keyValue, e);
        }
    }
}

