/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.jasig.schedassist;

import org.jasig.schedassist.model.ICalendarAccount;

/**
 * Thrown if a required {@link ICalendarAccount} cannot
 * be located.
 *  
 * @author Nicholas Blair, nblair@doit.wisc.edu
 * @version $Id: CalendarUserNotFoundException.java 1710 2010-02-15 16:19:35Z npblair $
 */
public class CalendarAccountNotFoundException extends Exception {

	private static final long serialVersionUID = 53706L;
	
	/**
	 * 
	 */
	public CalendarAccountNotFoundException() {
		super();
	}

	/**
	 * @param message
	 * @param cause
	 */
	public CalendarAccountNotFoundException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param message
	 */
	public CalendarAccountNotFoundException(String message) {
		super(message);
	}

	/**
	 * @param cause
	 */
	public CalendarAccountNotFoundException(Throwable cause) {
		super(cause);
	}

}
