/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.model;

import java.util.HashMap;
import java.util.Map;

public enum Preferences {
    NOTEBOARD("Noteboard", "owner.NOTEBOARD", ""),
    LOCATION("Meeting Location", "owner.LOCATION", "TBD"),
    MEETING_PREFIX("Meeting Title Prefix", "owner.PREFIX", "Appointment"),
    DURATIONS("Appointment Durations", "owner.DURATION", "30"),
    VISIBLE_WINDOW("Visible Window", "owner.VISIBLE_WINDOW", "24,3"),
    ADVISOR_SHARE_WITH_STUDENTS("Advisor: Share with Assigned Advisees", "advisor.SHARE_WITH_STUDENTS", "false"),
    DEFAULT_VISITOR_LIMIT("Default number of visitors per available block", "owner.DEFAULT_VISITOR_LIMIT", "1"),
    MEETING_LIMIT("Maximum number of meetings a visitor may have within window", "owner.MEETING_LIMIT", "-1"),
    REFLECT_SCHEDULE("Reflect Availability Schedule back to WiscCal as Daily Notes", "owner.REFLECT_SCHEDULE", "false"),
    REMINDERS("Send Reminders to visitors in advance of their appointments", "owner.EMAIL_REMINDERS", "false,false,24"),
    INSTRUCTOR_SHARE_WITH_STUDENTS("Instructor: Share with enrolled students", "instructor.SHARE_WITH_STUDENTS", "false");

    private String displayName;
    private String key;
    private String defaultValue = "";

    private Preferences(String displayName, String key) {
        this.displayName = displayName;
        this.key = key;
    }

    private Preferences(String displayName, String key, String defaultValue) {
        this.displayName = displayName;
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public static Preferences fromKey(String key) {
        for (Preferences single : Preferences.values()) {
            if (!single.getKey().equals(key)) continue;
            return single;
        }
        return null;
    }

    public static Preferences fromDisplayName(String displayName) {
        for (Preferences single : Preferences.values()) {
            if (!single.getDisplayName().equals(displayName)) continue;
            return single;
        }
        return null;
    }

    public static Map<Preferences, String> getDefaultPreferences() {
        HashMap<Preferences, String> prefs = new HashMap<Preferences, String>();
        for (Preferences single : Preferences.values()) {
            prefs.put(single, single.getDefaultValue());
        }
        return prefs;
    }
}

