/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.model;

import java.util.SortedSet;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.NullAffiliationSourceImpl;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.AvailableBlockBuilder;
import org.jasig.schedassist.model.AvailableSchedule;
import org.jasig.schedassist.model.DefaultEventUtilsImpl;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IEventUtils;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.IVisibleScheduleBuilder;
import org.jasig.schedassist.model.MeetingDurations;
import org.jasig.schedassist.model.SchedulingAssistantAppointment;
import org.jasig.schedassist.model.VisibleSchedule;

public class VisibleScheduleBuilder
implements IVisibleScheduleBuilder {
    private static Log LOG = LogFactory.getLog(VisibleScheduleBuilder.class);
    public static final String FREE = "free";
    public static final String BUSY = "busy";
    public static final String ATTENDING = "attending";
    private IEventUtils eventUtils = new DefaultEventUtilsImpl(new NullAffiliationSourceImpl());

    public VisibleScheduleBuilder() {
    }

    public VisibleScheduleBuilder(IEventUtils eventUtils) {
        this.eventUtils = eventUtils;
    }

    public void setEventUtils(IEventUtils eventUtils) {
        this.eventUtils = eventUtils;
    }

    @Override
    public VisibleSchedule calculateVisibleSchedule(java.util.Date startTime, java.util.Date endTime, Calendar calendar, AvailableSchedule schedule, IScheduleOwner owner) {
        return this.calculateVisibleScheduleNoAttendingCheck(startTime, endTime, calendar, schedule, owner.getPreferredMeetingDurations(), owner.getCalendarAccount());
    }

    @Override
    public VisibleSchedule calculateVisitorConflicts(java.util.Date startTime, java.util.Date endTime, Calendar calendar, AvailableSchedule schedule, MeetingDurations meetingDurations, IScheduleVisitor visitor) {
        return this.calculateVisibleScheduleNoAttendingCheck(startTime, endTime, calendar, schedule, meetingDurations, visitor.getCalendarAccount());
    }

    @Override
    public VisibleSchedule calculateVisibleSchedule(java.util.Date startTime, java.util.Date endTime, Calendar calendar, AvailableSchedule schedule, IScheduleOwner owner, IScheduleVisitor visitor) {
        Validate.notNull((Object)startTime, (String)"startTime cannot be null");
        Validate.notNull((Object)endTime, (String)"endTime cannot be null");
        Validate.notNull((Object)calendar, (String)"calendar cannot be null");
        Validate.notNull((Object)schedule, (String)"available schedule cannot be null");
        Validate.notNull((Object)owner, (String)"owner cannot be null");
        ICalendarAccount visitorCalendarAccount = null;
        if (visitor != null) {
            visitorCalendarAccount = visitor.getCalendarAccount();
        }
        if (endTime.before(startTime)) {
            throw new IllegalArgumentException("cannot pass end time (" + endTime + ") that is before start time (" + startTime + ")");
        }
        LOG.debug((Object)("startTime: " + startTime + "; endTime: " + endTime));
        MeetingDurations durations = owner.getPreferredMeetingDurations();
        SortedSet<AvailableBlock> availableBlocks = AvailableBlockBuilder.expand(schedule.getAvailableBlocks(), durations.getMinLength());
        AvailableBlock availabilityStartBlock = AvailableBlockBuilder.createPreferredMinimumDurationBlock(startTime, durations);
        AvailableBlock availabilityEndBlock = AvailableBlockBuilder.createPreferredMinimumDurationBlock(endTime, durations);
        availableBlocks = availableBlocks.subSet(availabilityStartBlock, availabilityEndBlock);
        VisibleSchedule visibleSchedule = new VisibleSchedule(durations);
        visibleSchedule.addFreeBlocks(availableBlocks);
        ComponentList events = calendar.getComponents("VEVENT");
        for (Object component : events) {
            VEvent event = (VEvent)component;
            boolean causesConflict = this.eventUtils.willEventCauseConflict(owner.getCalendarAccount(), event);
            if (!causesConflict) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("event will not cause conflict, skipping: " + event));
                continue;
            }
            if (this.eventUtils.isEventRecurring(event)) {
                PeriodList recurrenceList = this.eventUtils.calculateRecurrence(event, startTime, endTime);
                for (Object o : recurrenceList) {
                    Period period = (Period)o;
                    this.mutateAppropriateBlockInVisibleSchedule(visibleSchedule, event, owner.getCalendarAccount(), visitorCalendarAccount, (java.util.Date)period.getStart(), (java.util.Date)period.getEnd(), true);
                }
                continue;
            }
            Date startDate = event.getStartDate().getDate();
            Date endDate = event.getEndDate(true).getDate();
            this.mutateAppropriateBlockInVisibleSchedule(visibleSchedule, event, owner.getCalendarAccount(), visitorCalendarAccount, (java.util.Date)startDate, (java.util.Date)endDate, true);
        }
        return visibleSchedule;
    }

    protected VisibleSchedule calculateVisibleScheduleNoAttendingCheck(java.util.Date startTime, java.util.Date endTime, Calendar calendar, AvailableSchedule schedule, MeetingDurations meetingDurations, ICalendarAccount calendarAccount) {
        Validate.notNull((Object)startTime, (String)"startTime cannot be null");
        Validate.notNull((Object)endTime, (String)"endTime cannot be null");
        Validate.notNull((Object)calendar, (String)"calendar cannot be null");
        Validate.notNull((Object)meetingDurations, (String)"MeetingDurations argument cannot be null");
        Validate.notNull((Object)schedule, (String)"AvailableSchedule argument cannot be null");
        Validate.notNull((Object)calendarAccount, (String)"calendarAccount cannot be null");
        if (endTime.before(startTime)) {
            throw new IllegalArgumentException("cannot pass end time (" + endTime + ") that is before start time (" + startTime + ")");
        }
        LOG.debug((Object)("startTime: " + startTime + "; endTime: " + endTime));
        SortedSet<AvailableBlock> availableBlocks = AvailableBlockBuilder.expand(schedule.getAvailableBlocks(), meetingDurations.getMinLength());
        AvailableBlock availabilityStartBlock = AvailableBlockBuilder.createPreferredMinimumDurationBlock(startTime, meetingDurations);
        AvailableBlock availabilityEndBlock = AvailableBlockBuilder.createPreferredMinimumDurationBlock(endTime, meetingDurations);
        availableBlocks = availableBlocks.subSet(availabilityStartBlock, availabilityEndBlock);
        VisibleSchedule visibleSchedule = new VisibleSchedule(meetingDurations);
        visibleSchedule.addFreeBlocks(availableBlocks);
        ComponentList events = calendar.getComponents("VEVENT");
        for (Object component : events) {
            VEvent event = (VEvent)component;
            boolean causesConflict = this.eventUtils.willEventCauseConflict(calendarAccount, event);
            if (!causesConflict) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("event will not cause conflict, skipping: " + event));
                continue;
            }
            Date startDate = event.getStartDate().getDate();
            Date endDate = event.getEndDate(true).getDate();
            this.mutateAppropriateBlockInVisibleSchedule(visibleSchedule, event, calendarAccount, null, (java.util.Date)startDate, (java.util.Date)endDate, false);
            if (!this.eventUtils.isEventRecurring(event)) continue;
            PeriodList recurrenceList = this.eventUtils.calculateRecurrence(event, startTime, endTime);
            for (Object o : recurrenceList) {
                Period period = (Period)o;
                this.mutateAppropriateBlockInVisibleSchedule(visibleSchedule, event, calendarAccount, null, (java.util.Date)period.getStart(), (java.util.Date)period.getEnd(), false);
            }
        }
        return visibleSchedule;
    }

    void mutateAppropriateBlockInVisibleSchedule(VisibleSchedule visibleSchedule, VEvent event, ICalendarAccount owner, ICalendarAccount visitor, java.util.Date eventInstanceStartDate, java.util.Date eventInstanceEndDate, boolean performAttendingCheck) {
        int visitorLimit = this.safeVisitorLimit(event);
        AvailableBlock eventBlock = AvailableBlockBuilder.createBlock(eventInstanceStartDate, eventInstanceEndDate, visitorLimit);
        Property availableEventMarker = event.getProperty("X-UW-AVAILABLE-APPOINTMENT");
        if (null == availableEventMarker || !SchedulingAssistantAppointment.TRUE.equals(availableEventMarker)) {
            visibleSchedule.setBusyBlock(eventBlock);
        } else if (performAttendingCheck && null != visitor && this.eventUtils.isAttendingAsOwner(event, owner) && this.eventUtils.isAttendingAsVisitor(event, visitor)) {
            visibleSchedule.setAttendingBlock(eventBlock);
        } else if (this.eventUtils.isAttendingAsOwner(event, owner)) {
            int availableVisitorCount = this.eventUtils.getScheduleVisitorCount(event);
            if (availableVisitorCount >= visitorLimit) {
                visibleSchedule.setBusyBlock(eventBlock);
            } else {
                eventBlock.setVisitorsAttending(availableVisitorCount);
                visibleSchedule.overwriteFreeBlockOnlyIfPresent(eventBlock);
            }
        } else {
            visibleSchedule.setBusyBlock(eventBlock);
        }
    }

    int safeVisitorLimit(VEvent event) {
        Integer visitorLimit = this.eventUtils.getEventVisitorLimit(event);
        if (visitorLimit == null) {
            return 1;
        }
        return visitorLimit;
    }
}

