/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.model;

import java.util.Date;
import org.apache.commons.lang.time.DateUtils;

public final class VisibleWindow {
    private String key;
    private int windowHoursStart;
    private int windowWeeksEnd;
    public static VisibleWindow DEFAULT = new VisibleWindow("24,3", 24, 3);

    VisibleWindow(String key, int windowHoursStart, int windowWeeksEnd) {
        this.key = key;
        this.windowHoursStart = windowHoursStart;
        this.windowWeeksEnd = windowWeeksEnd;
    }

    public String getKey() {
        return this.key;
    }

    public int getWindowHoursStart() {
        return this.windowHoursStart;
    }

    public int getWindowWeeksEnd() {
        return this.windowWeeksEnd;
    }

    public Date calculateCurrentWindowStart() {
        Date start = DateUtils.addHours((Date)new Date(), (int)this.windowHoursStart);
        return DateUtils.truncate((Date)start, (int)12);
    }

    public Date calculateCurrentWindowEnd() {
        Date end = DateUtils.addWeeks((Date)new Date(), (int)this.windowWeeksEnd);
        return DateUtils.truncate((Date)end, (int)12);
    }

    public static VisibleWindow fromKey(String key) {
        String[] tokens = key.split(",");
        if (tokens.length != 2) {
            throw new IllegalArgumentException("key must be formatted as 'start,end': " + key);
        }
        try {
            int minValue = Integer.parseInt(tokens[0]);
            int maxValue = Integer.parseInt(tokens[1]);
            VisibleWindow window = new VisibleWindow(key, minValue, maxValue);
            return window;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("values must be integers: " + key, e);
        }
    }
}

