/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.model;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.time.DateUtils;

public final class AvailableBlock
implements Comparable<AvailableBlock>,
Serializable {
    private static final long serialVersionUID = -7574365284572265106L;
    private static int MILLISECONDS_PER_MINUTE = 60000;
    private final Date startTime;
    private final Date endTime;
    private final int visitorLimit;
    private final String meetingLocation;
    private int visitorsAttending = 0;

    AvailableBlock(Date startTime, Date endTime) {
        this(startTime, endTime, 1);
    }

    AvailableBlock(Date startTime, Date endTime, int visitorLimit) {
        this(startTime, endTime, visitorLimit, null);
    }

    AvailableBlock(Date startTime, Date endTime, int visitorLimit, String meetingLocation) {
        Validate.notNull((Object)startTime, (String)"startTime cannot be null");
        Validate.notNull((Object)endTime, (String)"endTime cannot be null");
        if (endTime.before(startTime) || endTime.equals(startTime)) {
            throw new IllegalArgumentException("startTime (" + startTime + ") must precede endTime (" + endTime + ")");
        }
        if (visitorLimit < 1) {
            throw new IllegalArgumentException("visitorLimit must be greater than or equal to 1: " + visitorLimit);
        }
        this.startTime = DateUtils.truncate((Date)startTime, (int)12);
        this.endTime = DateUtils.truncate((Date)endTime, (int)12);
        this.visitorLimit = visitorLimit;
        this.meetingLocation = meetingLocation;
    }

    AvailableBlock(AvailableBlock sourceBlock) {
        this.startTime = sourceBlock.startTime;
        this.endTime = sourceBlock.endTime;
        this.visitorLimit = sourceBlock.visitorLimit;
        this.meetingLocation = sourceBlock.meetingLocation;
    }

    public Date getEndTime() {
        return new Date(this.endTime.getTime());
    }

    public Date getStartTime() {
        return new Date(this.startTime.getTime());
    }

    public int getVisitorLimit() {
        return this.visitorLimit;
    }

    public String getMeetingLocation() {
        return this.meetingLocation;
    }

    public int getDurationInMinutes() {
        long start = this.startTime.getTime();
        long end = this.endTime.getTime();
        int minutes = (int)(end - start) / MILLISECONDS_PER_MINUTE;
        return minutes;
    }

    public void setVisitorsAttending(int visitorsAttending) {
        this.visitorsAttending = visitorsAttending;
    }

    public int getVisitorsAttending() {
        return this.visitorsAttending;
    }

    @Override
    public int compareTo(AvailableBlock o) {
        return new CompareToBuilder().append((Object)this.startTime, (Object)o.startTime).append((Object)this.endTime, (Object)o.endTime).toComparison();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AvailableBlock)) {
            return false;
        }
        AvailableBlock rhs = (AvailableBlock)object;
        return new EqualsBuilder().append((Object)this.startTime, (Object)rhs.startTime).append((Object)this.endTime, (Object)rhs.endTime).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("endTime", (Object)this.endTime).append("startTime", (Object)this.startTime).append("visitorLimit", this.visitorLimit).append("visitorsAttending", this.visitorsAttending).append("meetingLocation", (Object)this.meetingLocation).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(-1720909897, 187194383).append((Object)this.startTime).append((Object)this.endTime).toHashCode();
    }
}

