/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.AvailableBlockBuilder;
import org.jasig.schedassist.model.AvailableStatus;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.MeetingDurations;

public class VisibleSchedule
implements Serializable {
    private static final long serialVersionUID = -8774450894322731603L;
    private Log LOG = LogFactory.getLog(this.getClass());
    private SortedMap<AvailableBlock, AvailableStatus> blockMap = new TreeMap<AvailableBlock, AvailableStatus>();
    private final MeetingDurations meetingDurations;

    public VisibleSchedule(MeetingDurations meetingDurations) {
        this.meetingDurations = meetingDurations;
    }

    public void addFreeBlock(AvailableBlock block) {
        SortedSet<AvailableBlock> expanded = AvailableBlockBuilder.expand(block, this.meetingDurations.getMinLength());
        for (AvailableBlock small : expanded) {
            if (this.blockMap.containsKey(small)) {
                this.blockMap.remove(small);
            }
            this.blockMap.put(small, AvailableStatus.FREE);
        }
    }

    public void overwriteFreeBlockOnlyIfPresent(AvailableBlock block) {
        if (this.blockMap.containsKey(block)) {
            this.blockMap.remove(block);
            this.blockMap.put(block, AvailableStatus.FREE);
        }
    }

    public void addFreeBlocks(Collection<AvailableBlock> blocks) {
        for (AvailableBlock block : blocks) {
            this.addFreeBlock(block);
        }
    }

    public void setBusyBlock(AvailableBlock block) {
        if (this.blockMap.containsKey(block)) {
            this.blockMap.put(block, AvailableStatus.BUSY);
        } else {
            this.LOG.debug((Object)("setBusyBlock on non-matching block: " + block));
            Set<AvailableBlock> conflicting = this.locateConflicting(block);
            for (AvailableBlock conflict : conflicting) {
                this.blockMap.put(conflict, AvailableStatus.BUSY);
            }
        }
    }

    public void setBusyBlocks(Collection<AvailableBlock> blocks) {
        for (AvailableBlock block : blocks) {
            this.setBusyBlock(block);
        }
    }

    public void setAttendingBlock(AvailableBlock block) {
        if (this.blockMap.containsKey(block)) {
            this.blockMap.put(block, AvailableStatus.ATTENDING);
        } else {
            Set<AvailableBlock> conflicting = this.locateConflicting(block);
            if (conflicting.size() > 0) {
                for (AvailableBlock conflict : conflicting) {
                    this.blockMap.remove(conflict);
                }
                this.blockMap.put(block, AvailableStatus.ATTENDING);
            }
        }
    }

    public void setAttendingBlocks(Collection<AvailableBlock> blocks) {
        for (AvailableBlock block : blocks) {
            this.setAttendingBlock(block);
        }
    }

    public SortedMap<AvailableBlock, AvailableStatus> getBlockMap() {
        return new TreeMap<AvailableBlock, AvailableStatus>(this.blockMap);
    }

    public int getSize() {
        return this.blockMap.size();
    }

    public int getFreeCount() {
        return this.getCountForStatus(AvailableStatus.FREE);
    }

    public int getBusyCount() {
        return this.getCountForStatus(AvailableStatus.BUSY);
    }

    public int getAttendingCount() {
        return this.getCountForStatus(AvailableStatus.ATTENDING);
    }

    public List<AvailableBlock> getFreeList() {
        return this.getBlockListForStatus(AvailableStatus.FREE);
    }

    public List<AvailableBlock> getBusyList() {
        return this.getBlockListForStatus(AvailableStatus.BUSY);
    }

    public List<AvailableBlock> getAttendingList() {
        return this.getBlockListForStatus(AvailableStatus.ATTENDING);
    }

    public java.util.Date getScheduleStart() {
        if (this.blockMap.isEmpty()) {
            return null;
        }
        AvailableBlock firstKey = this.blockMap.firstKey();
        return firstKey == null ? null : firstKey.getStartTime();
    }

    public java.util.Date getScheduleEnd() {
        if (this.blockMap.isEmpty()) {
            return null;
        }
        AvailableBlock lastKey = this.blockMap.lastKey();
        return lastKey == null ? null : lastKey.getEndTime();
    }

    public Calendar getCalendar() {
        ComponentList components = new ComponentList();
        for (Map.Entry<AvailableBlock, AvailableStatus> mapEntry : this.blockMap.entrySet()) {
            AvailableBlock block = mapEntry.getKey();
            AvailableStatus status = mapEntry.getValue();
            StringBuilder eventTitle = new StringBuilder();
            if (block.getVisitorLimit() > 1 && AvailableStatus.FREE.equals((Object)status)) {
                eventTitle.append("(");
                eventTitle.append(block.getVisitorLimit() - block.getVisitorsAttending());
                eventTitle.append("/");
                eventTitle.append(block.getVisitorLimit());
                eventTitle.append(") ");
            }
            eventTitle.append(status.getValue());
            VEvent event = new VEvent((Date)new DateTime(block.getStartTime()), (Date)new DateTime(block.getEndTime()), eventTitle.toString());
            components.add((Component)event);
        }
        Calendar result = new Calendar(components);
        return result;
    }

    public VisibleSchedule subset(java.util.Date start, java.util.Date end) {
        VisibleSchedule result = new VisibleSchedule(this.meetingDurations);
        for (Map.Entry<AvailableBlock, AvailableStatus> e : this.blockMap.entrySet()) {
            AvailableBlock block = e.getKey();
            AvailableStatus status = e.getValue();
            if (!CommonDateOperations.equalsOrAfter(block.getStartTime(), start) || !CommonDateOperations.equalsOrBefore(block.getEndTime(), end)) continue;
            result.addFreeBlock(block);
            switch (status) {
                case FREE: {
                    break;
                }
                case BUSY: {
                    result.setBusyBlock(block);
                    break;
                }
                case ATTENDING: {
                    result.setAttendingBlock(block);
                    break;
                }
                case UNAVAILABLE: {
                    throw new IllegalStateException("unexpected status (" + (Object)((Object)status) + ") for block " + block);
                }
            }
        }
        return result;
    }

    protected Set<AvailableBlock> locateConflicting(AvailableBlock conflict) {
        HashSet<AvailableBlock> conflictingKeys = new HashSet<AvailableBlock>();
        java.util.Date conflictDayStart = DateUtils.truncate((java.util.Date)conflict.getStartTime(), (int)5);
        java.util.Date conflictDayEnd = DateUtils.addDays((java.util.Date)DateUtils.truncate((java.util.Date)conflict.getEndTime(), (int)5), (int)1);
        conflictDayEnd = DateUtils.addMinutes((java.util.Date)conflictDayEnd, (int)-1);
        AvailableBlock rangeStart = AvailableBlockBuilder.createPreferredMinimumDurationBlock(conflictDayStart, this.meetingDurations);
        this.LOG.debug((Object)("rangeStart: " + rangeStart));
        AvailableBlock rangeEnd = AvailableBlockBuilder.createBlockEndsAt(conflictDayEnd, this.meetingDurations.getMinLength());
        this.LOG.debug((Object)("rangeEnd: " + rangeStart));
        SortedMap<AvailableBlock, AvailableStatus> subMap = this.blockMap.subMap(rangeStart, rangeEnd);
        this.LOG.debug((Object)("subset of blockMap size: " + subMap.size()));
        for (AvailableBlock mapKey : subMap.keySet()) {
            java.util.Date minuteWithinBlock = DateUtils.addSeconds((java.util.Date)mapKey.getStartTime(), (int)10);
            boolean shortCircuit = true;
            while (shortCircuit && CommonDateOperations.equalsOrBefore(minuteWithinBlock, mapKey.getEndTime())) {
                if (minuteWithinBlock.before(conflict.getEndTime()) && minuteWithinBlock.after(conflict.getStartTime())) {
                    conflictingKeys.add(mapKey);
                    shortCircuit = false;
                }
                minuteWithinBlock = DateUtils.addMinutes((java.util.Date)minuteWithinBlock, (int)1);
            }
        }
        return conflictingKeys;
    }

    protected int getCountForStatus(AvailableStatus targetStatus) {
        int count = 0;
        for (AvailableStatus status : this.blockMap.values()) {
            if (!targetStatus.equals((Object)status)) continue;
            ++count;
        }
        return count;
    }

    protected List<AvailableBlock> getBlockListForStatus(AvailableStatus targetStatus) {
        ArrayList<AvailableBlock> results = new ArrayList<AvailableBlock>();
        for (Map.Entry<AvailableBlock, AvailableStatus> mapEntry : this.blockMap.entrySet()) {
            AvailableStatus status = mapEntry.getValue();
            if (!targetStatus.equals((Object)status)) continue;
            AvailableBlock block = mapEntry.getKey();
            results.add(block);
        }
        return results;
    }
}

