/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.portlet.web;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.portlet.PortletSchedulingAssistantService;
import org.jasig.schedassist.portlet.webflow.FlowHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;

@Controller
public class VisitorConflictsController {
    private Log LOG = LogFactory.getLog(this.getClass());
    private PortletSchedulingAssistantService schedulingAssistantService;

    @Autowired
    public void setPortletAvailableService(@Qualifier(value="ajax") PortletSchedulingAssistantService schedulingAssistantService) {
        this.schedulingAssistantService = schedulingAssistantService;
    }

    @RequestMapping(value={"/ajax/visitor-conflicts.json"})
    public String getVisitorConflicts(@RequestParam(value="ownerId") long ownerId, @RequestParam(value="weekStart") int weekStart, ModelMap model, WebRequest request) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("enter getVisitorConflicts, ownerId: " + ownerId + ", weekStart: " + weekStart));
        }
        String visitorUsername = (String)request.getAttribute(FlowHelper.CURRENT_USER_ATTR, 1);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("visitorUsername: " + visitorUsername));
        }
        if (StringUtils.isBlank((String)visitorUsername)) {
            model.addAttribute("soup for you", (Object)"none");
            return "jsonView";
        }
        List conflicts = this.schedulingAssistantService.calculateVisitorConflicts(visitorUsername, ownerId, weekStart);
        Collections.sort(conflicts);
        ArrayList<String> conflictBlocks = new ArrayList<String>();
        SimpleDateFormat df = CommonDateOperations.getDateTimeFormat();
        for (AvailableBlock b : conflicts) {
            conflictBlocks.add(df.format(b.getStartTime()));
        }
        model.addAttribute("conflicts", conflictBlocks);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"exit getVisitorConflicts");
        }
        return "jsonView";
    }
}

