/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.portlet;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.AvailableStatus;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.VisibleSchedule;
import org.springframework.context.MessageSource;
import org.springframework.web.servlet.tags.RequestContextAwareTag;

public class VisibleScheduleTag
extends RequestContextAwareTag {
    protected static final String PORTLET_REQUEST = "javax.portlet.request";
    protected static final String PORTLET_RESPONSE = "javax.portlet.response";
    private static final long serialVersionUID = 53706L;
    private Log LOG = LogFactory.getLog(this.getClass());
    private VisibleSchedule visibleSchedule;
    private boolean previewMode = false;
    private String resourceServerContext = "/ResourceServingWebapp";
    private String flowExecutionKey;

    public void setVisibleSchedule(VisibleSchedule visibleSchedule) {
        this.visibleSchedule = visibleSchedule;
    }

    public void setPreviewMode(boolean previewMode) {
        this.previewMode = previewMode;
    }

    public void setResourceServerContext(String resourceServerContext) {
        this.resourceServerContext = resourceServerContext;
    }

    public void setFlowExecutionKey(String flowExecutionKey) {
        this.flowExecutionKey = flowExecutionKey;
    }

    public MessageSource getMessageSource() {
        return this.getRequestContext().getMessageSource();
    }

    protected String getSilkIconPrefix() {
        String silkPrefix = this.resourceServerContext + "/rs/famfamfam/silk/1.3/";
        return silkPrefix;
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    public int doStartTagInternal() {
        RenderRequest renderRequest = (RenderRequest)this.pageContext.getRequest().getAttribute(PORTLET_REQUEST);
        RenderResponse renderResponse = (RenderResponse)this.pageContext.getRequest().getAttribute(PORTLET_RESPONSE);
        Date scheduleStart = this.visibleSchedule.getScheduleStart();
        if (null == scheduleStart) {
            try {
                StringBuilder noappointments = new StringBuilder();
                noappointments.append("<span class=\"none-available\">");
                noappointments.append(this.getMessageSource().getMessage("no.available.appointments", null, null));
                noappointments.append("</span>");
                this.pageContext.getOut().write(noappointments.toString());
            }
            catch (IOException e) {
                this.LOG.error((Object)"IOException occurred in doStartTag", (Throwable)e);
            }
            return 0;
        }
        this.LOG.debug((Object)("scheduleStart: " + scheduleStart));
        TreeMap dailySchedules = new TreeMap();
        Date index = DateUtils.truncate((Date)scheduleStart, (int)5);
        Date scheduleEnd = this.visibleSchedule.getScheduleEnd();
        while (index.before(scheduleEnd)) {
            dailySchedules.put(index, new ArrayList());
            index = DateUtils.addDays((Date)index, (int)1);
        }
        Date lastMapKey = (Date)dailySchedules.lastKey();
        this.LOG.debug((Object)("visibleSchedule spans " + dailySchedules.keySet().size() + " days"));
        try {
            SortedMap scheduleBlockMap = this.visibleSchedule.getBlockMap();
            int numberOfEventsToDisplay = 0;
            for (AvailableBlock block : scheduleBlockMap.keySet()) {
                Date eventStartDate = block.getStartTime();
                this.LOG.debug((Object)("event start date: " + eventStartDate));
                Date mapKey = DateUtils.truncate((Date)eventStartDate, (int)5);
                if (!CommonDateOperations.equalsOrAfter((Date)eventStartDate, (Date)scheduleStart) || !dailySchedules.containsKey(mapKey)) continue;
                ((List)dailySchedules.get(mapKey)).add(block);
                ++numberOfEventsToDisplay;
            }
            this.LOG.debug((Object)("number of events to display: " + numberOfEventsToDisplay));
            if (numberOfEventsToDisplay == 0) {
                StringBuilder noappointments = new StringBuilder();
                noappointments.append("<span class=\"none-available\">");
                noappointments.append(this.getMessageSource().getMessage("no.available.appointments", null, null));
                noappointments.append("</span>");
                this.pageContext.getOut().write(noappointments.toString());
            } else {
                int weekNumber = 1;
                Date currentWeekStart = DateUtils.truncate((Date)scheduleStart, (int)5);
                Date currentWeekFinish = DateUtils.addDays((Date)currentWeekStart, (int)CommonDateOperations.numberOfDaysUntilSunday((Date)currentWeekStart));
                currentWeekFinish = DateUtils.addMinutes((Date)currentWeekFinish, (int)-1);
                boolean renderAnotherWeek = true;
                while (renderAnotherWeek) {
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug((Object)("will render another week using currentWeekStart " + currentWeekStart + " and currentWeekFinish " + currentWeekFinish));
                    }
                    SortedMap subMap = dailySchedules.subMap(currentWeekStart, currentWeekFinish);
                    this.renderWeek(this.pageContext.getOut(), weekNumber++, subMap, scheduleBlockMap, renderRequest, renderResponse);
                    currentWeekStart = DateUtils.addMinutes((Date)currentWeekFinish, (int)1);
                    currentWeekFinish = DateUtils.addDays((Date)currentWeekStart, (int)7);
                    currentWeekFinish = DateUtils.addMinutes((Date)currentWeekFinish, (int)-1);
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug((Object)("recalculated currentWeekStart " + currentWeekStart + ", currentWeekFinish " + currentWeekFinish));
                    }
                    if (!currentWeekStart.after(lastMapKey)) continue;
                    renderAnotherWeek = false;
                    this.LOG.debug((Object)"will not render another week");
                }
            }
        }
        catch (IOException e) {
            this.LOG.error((Object)"IOException occurred in doStartTag", (Throwable)e);
        }
        return 0;
    }

    protected boolean doesWeekHaveBlocks(Map<Date, List<AvailableBlock>> dailySchedules) {
        for (Map.Entry<Date, List<AvailableBlock>> entry : dailySchedules.entrySet()) {
            List<AvailableBlock> daySchedule = entry.getValue();
            if (daySchedule.size() <= 0) continue;
            return true;
        }
        return false;
    }

    protected void renderWeek(JspWriter writer, int weekNumber, SortedMap<Date, List<AvailableBlock>> dailySchedules, SortedMap<AvailableBlock, AvailableStatus> scheduleBlockMap, RenderRequest renderRequest, RenderResponse renderResponse) throws IOException {
        boolean hasBlocks;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("begin renderWeek for " + weekNumber));
        }
        if (hasBlocks = this.doesWeekHaveBlocks(dailySchedules)) {
            SimpleDateFormat headFormat = new SimpleDateFormat("EEE M/d");
            writer.write("<div class=\"weekcontainer\" id=\"week" + weekNumber + "\">");
            for (Map.Entry<Date, List<AvailableBlock>> entry : dailySchedules.entrySet()) {
                Date day = entry.getKey();
                List<AvailableBlock> daySchedule = entry.getValue();
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("in renderWeek weeknumber: " + weekNumber + ", day: " + day));
                }
                if (daySchedule.size() <= 0) continue;
                writer.write("<div class=\"weekday\">");
                writer.write("<ul>");
                writer.write("<li class=\"dayhead\">");
                writer.write(headFormat.format(day));
                writer.write("</li>");
                for (AvailableBlock event : daySchedule) {
                    AvailableStatus eventStatus = (AvailableStatus)scheduleBlockMap.get(event);
                    if (AvailableStatus.BUSY.equals((Object)eventStatus)) {
                        this.renderBusyBlock(writer, event);
                        continue;
                    }
                    if (AvailableStatus.FREE.equals((Object)eventStatus)) {
                        this.renderFreeBlock(writer, event, renderRequest, renderResponse);
                        continue;
                    }
                    if (!AvailableStatus.ATTENDING.equals((Object)eventStatus)) continue;
                    this.renderAttendingBlock(writer, event, renderRequest, renderResponse);
                }
                writer.write("</ul>");
                writer.write("</div> <!-- end weekday -->");
            }
            writer.write("</div> <!-- end weekcontainer -->");
        } else if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("renderWeek has no blocks for weekNumber: " + weekNumber));
        }
    }

    protected void renderBusyBlock(JspWriter writer, AvailableBlock event) throws IOException {
        SimpleDateFormat idFormat = CommonDateOperations.getDateTimeFormat();
        SimpleDateFormat timeFormat = new SimpleDateFormat("h:mm a");
        String busyTitle = this.getMessageSource().getMessage("busy.shortdescription", null, null);
        writer.write("<li id=\"" + idFormat.format(event.getStartTime()) + "\" class=\"busy\" title=\"" + busyTitle + "\">");
        writer.write("<img src=\"" + this.getSilkIconPrefix() + "delete.png\" alt=\"\"/>&nbsp;");
        writer.write("<span id=\"" + idFormat.format(event.getStartTime()) + "-text\">");
        writer.write(timeFormat.format(event.getStartTime()));
        writer.write(" - ");
        writer.write(timeFormat.format(event.getEndTime()));
        writer.write("</span>");
        writer.write("</li>");
    }

    protected void renderFreeBlock(JspWriter writer, AvailableBlock event, RenderRequest renderRequest, RenderResponse renderResponse) throws IOException {
        SimpleDateFormat stpFormat = new SimpleDateFormat("yyyyMMdd-HHmm");
        SimpleDateFormat idFormat = CommonDateOperations.getDateTimeFormat();
        SimpleDateFormat timeFormat = new SimpleDateFormat("h:mm a");
        SimpleDateFormat readableFormat = new SimpleDateFormat("EEE MMM d");
        String appointmentTitle = event.getVisitorLimit() > 1 ? this.getMessageSource().getMessage("join.appointment.for", new Object[]{readableFormat.format(event.getStartTime()), Integer.toString(event.getVisitorLimit() - event.getVisitorsAttending()), event.getVisitorLimit()}, null) : this.getMessageSource().getMessage("create.appointment.for", new Object[]{readableFormat.format(event.getStartTime())}, null);
        writer.write("<li id=\"" + idFormat.format(event.getStartTime()) + "\" class=\"free\" title=\"" + appointmentTitle.toString() + "\">");
        if (!this.previewMode) {
            PortletURL createUrl = renderResponse.createRenderURL();
            createUrl.setParameter("_eventId", "create");
            createUrl.setParameter("execution", this.flowExecutionKey);
            createUrl.setParameter("startTime", stpFormat.format(event.getStartTime()));
            createUrl.setParameter("ownerId", renderRequest.getParameter("ownerId"));
            writer.write("<a href=\"" + createUrl.toString() + "\">");
        }
        if (event.getVisitorLimit() > 1) {
            writer.write("<img src=\"" + this.getSilkIconPrefix() + "group.png\" alt=\"\"/>&nbsp;");
        } else {
            writer.write("<img src=\"" + this.getSilkIconPrefix() + "calendar_add.png\" alt=\"\"/>&nbsp;");
        }
        writer.write("<span id=\"" + idFormat.format(event.getStartTime()) + "-text\">");
        writer.write(timeFormat.format(event.getStartTime()));
        writer.write(" - ");
        writer.write(timeFormat.format(event.getEndTime()));
        writer.write("</span>");
        if (!this.previewMode) {
            writer.write("</a>");
        }
        writer.write("</li>");
    }

    protected void renderAttendingBlock(JspWriter writer, AvailableBlock event, RenderRequest renderRequest, RenderResponse renderResponse) throws IOException {
        SimpleDateFormat stpFormat = new SimpleDateFormat("yyyyMMdd-HHmm");
        SimpleDateFormat idFormat = CommonDateOperations.getDateTimeFormat();
        SimpleDateFormat timeFormat = new SimpleDateFormat("h:mm a");
        String startTimeFormatted = stpFormat.format(event.getStartTime());
        String endTimeFormatted = stpFormat.format(event.getEndTime());
        String cancelTitle = this.getMessageSource().getMessage("cancel.my.appointment", null, null);
        writer.write("<li id=\"" + idFormat.format(event.getStartTime()) + "\" class=\"attending\" title=\"" + cancelTitle + "\">");
        if (!this.previewMode) {
            PortletURL cancelUrl = renderResponse.createRenderURL();
            cancelUrl.setParameter("execution", this.flowExecutionKey);
            cancelUrl.setParameter("_eventId", "cancel");
            cancelUrl.setParameter("startTime", startTimeFormatted);
            cancelUrl.setParameter("endTime", endTimeFormatted);
            cancelUrl.setParameter("ownerId", renderRequest.getParameter("ownerId"));
            writer.write("<a href=\"" + cancelUrl.toString() + "\">");
        }
        writer.write("<img src=\"" + this.getSilkIconPrefix() + "calendar_delete.png\" alt=\"\"/>&nbsp;");
        writer.write("<span id=\"" + idFormat.format(event.getStartTime()) + "-text\">");
        writer.write(timeFormat.format(event.getStartTime()));
        writer.write(" - ");
        writer.write(timeFormat.format(event.getEndTime()));
        writer.write("</span>");
        if (!this.previewMode) {
            writer.write("</a>");
        }
        writer.write("</li>");
    }
}

