/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.portlet.webflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.MeetingDurations;

public class CreateAppointmentFormBackingObject
implements Serializable {
    private static final long serialVersionUID = 9118729275677888220L;
    private final AvailableBlock targetBlock;
    private final MeetingDurations meetingDurations;
    private String reason;
    private int selectedDuration;
    private boolean confirmJoin = false;

    public CreateAppointmentFormBackingObject(AvailableBlock targetBlock, MeetingDurations meetingDurations) {
        this.targetBlock = targetBlock;
        this.meetingDurations = meetingDurations;
    }

    public AvailableBlock getTargetBlock() {
        return this.targetBlock;
    }

    public MeetingDurations getMeetingDurations() {
        return this.meetingDurations;
    }

    public boolean isMultipleVisitors() {
        return this.targetBlock.getVisitorLimit() > 1;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean isDoubleLengthAvailable() {
        return !this.isMultipleVisitors() && this.meetingDurations.isDoubleLength();
    }

    public List<Integer> getMeetingDurationsAsList() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(this.meetingDurations.getMinLength());
        if (this.meetingDurations.isDoubleLength()) {
            result.add(this.meetingDurations.getMaxLength());
        }
        return result;
    }

    public int getSelectedDuration() {
        if (!this.meetingDurations.isDoubleLength()) {
            return this.meetingDurations.getMinLength();
        }
        return this.selectedDuration;
    }

    public void setSelectedDuration(int selectedDuration) {
        this.selectedDuration = selectedDuration;
    }

    public boolean isConfirmJoin() {
        return this.confirmJoin;
    }

    public void setConfirmJoin(boolean confirmJoin) {
        this.confirmJoin = confirmJoin;
    }
}

