/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.portlet.webflow;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.SchedulingException;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.Preferences;
import org.jasig.schedassist.model.Relationship;
import org.jasig.schedassist.model.VisibleSchedule;
import org.jasig.schedassist.model.VisibleScheduleRequestConstraints;
import org.jasig.schedassist.model.VisibleWindow;
import org.jasig.schedassist.portlet.EventCancellation;
import org.jasig.schedassist.portlet.PortletSchedulingAssistantService;
import org.jasig.schedassist.portlet.ScheduleOwnerNotFoundException;
import org.jasig.schedassist.portlet.webflow.CancelAppointmentFormBackingObject;
import org.jasig.schedassist.portlet.webflow.CreateAppointmentFormBackingObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

@Service(value="flowHelper")
public class FlowHelper {
    private Log LOG = LogFactory.getLog(this.getClass());
    private PortletSchedulingAssistantService schedulingAssistantService;
    private String availableWebBaseUrl;
    private String advisorUrl;
    private String profileSearchUrl;
    public static final String CURRENT_USER_ATTR = FlowHelper.class.getName() + ".CURRENT_USER";

    @Autowired
    public void setPortletAvailableService(@Qualifier(value="portlet") PortletSchedulingAssistantService schedulingAssistantService) {
        this.schedulingAssistantService = schedulingAssistantService;
    }

    @Autowired
    public void setAvailableWebBaseUrl(String availableWebBaseUrl) {
        Validate.notEmpty((String)availableWebBaseUrl, (String)"availableWebBaseUrl property must not be empty");
        this.availableWebBaseUrl = availableWebBaseUrl;
        if (!this.availableWebBaseUrl.endsWith("/")) {
            this.availableWebBaseUrl = this.availableWebBaseUrl + "/";
        }
        this.advisorUrl = this.availableWebBaseUrl + "public/advisors.html";
        this.profileSearchUrl = this.availableWebBaseUrl + "public/index.html";
    }

    public String getAvailableWebBaseUrl() {
        return this.availableWebBaseUrl;
    }

    public String getAdvisorUrl() {
        return this.advisorUrl;
    }

    public String getProfileSearchUrl() {
        return this.profileSearchUrl;
    }

    public void setNormalWindowState(ExternalContext context) {
        MutableAttributeMap map = context.getRequestMap();
        map.put("portletWindowState", (Object)WindowState.NORMAL);
    }

    public Date convertDateTime(String dateTimePhrase) throws ParseException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("convertDateTime called on " + dateTimePhrase));
        }
        SimpleDateFormat df = CommonDateOperations.getDateTimeFormat();
        return df.parse(dateTimePhrase);
    }

    public String getCurrentVisitorUsername() {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        PortletRequest request = (PortletRequest)requestContext.getExternalContext().getNativeRequest();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("current visitor username " + request.getRemoteUser()));
        }
        String remoteUser = request.getRemoteUser();
        PortletSession portletSession = request.getPortletSession();
        portletSession.setAttribute(CURRENT_USER_ATTR, (Object)remoteUser, 1);
        return remoteUser;
    }

    public boolean isCurrentVisitorEligible() {
        return this.schedulingAssistantService.isEligible(this.getCurrentVisitorUsername());
    }

    public List<Relationship> getRelationshipsForCurrentVisitor() {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"enter getRelationshipsForCurrentVisitor");
        }
        String visitorUsername = this.getCurrentVisitorUsername();
        List relationships = this.schedulingAssistantService.relationshipsForVisitor(visitorUsername);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("found " + relationships.size() + " relationships"));
        }
        return relationships;
    }

    public boolean isOwnerSamePersonAsCurrentVisitor(IScheduleOwner owner) {
        return owner.getCalendarAccount().getUsername().equals(this.getCurrentVisitorUsername());
    }

    public IScheduleOwner identifyTargetOwner(long ownerId) throws ScheduleOwnerNotFoundException {
        List relationships = this.getRelationshipsForCurrentVisitor();
        IScheduleOwner target = null;
        for (Relationship r : relationships) {
            if (r.getOwner().getId() != ownerId) continue;
            target = r.getOwner();
            break;
        }
        if (null == target) {
            throw new ScheduleOwnerNotFoundException(ownerId + " not found");
        }
        return target;
    }

    public String getOwnerNoteboard(IScheduleOwner owner) {
        if (null == owner) {
            return "";
        }
        return owner.getPreference(Preferences.NOTEBOARD);
    }

    public List<String> getOwnerNoteboardSentences(IScheduleOwner owner) {
        if (null == owner) {
            return Collections.emptyList();
        }
        String ownerNoteboard = owner.getPreference(Preferences.NOTEBOARD);
        String[] sentences = ownerNoteboard.split("\n");
        return Arrays.asList(sentences);
    }

    public String testExceededMeetingLimit(IScheduleOwner owner) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("enter testExceededMeetingLimit for " + owner));
        }
        String visitorUsername = this.getCurrentVisitorUsername();
        if (owner.hasMeetingLimit()) {
            VisibleSchedule schedule = this.schedulingAssistantService.getVisibleSchedule(visitorUsername, owner.getId());
            if (owner.isExceedingMeetingLimit(schedule.getAttendingCount())) {
                return "yes";
            }
            return "no";
        }
        return "no";
    }

    public VisibleSchedule getVisibleSchedule(IScheduleOwner owner, String weekStartParam) throws ScheduleOwnerNotFoundException {
        return this.getVisibleSchedule(owner, this.safeConvertWeekStartParam(weekStartParam));
    }

    public VisibleSchedule getVisibleSchedule(IScheduleOwner owner, int weekStart) throws ScheduleOwnerNotFoundException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("enter getVisibleSchedule, weekstart: " + weekStart + ", owner: " + owner));
        }
        String visitorUsername = this.getCurrentVisitorUsername();
        VisibleSchedule schedule = this.schedulingAssistantService.getVisibleSchedule(visitorUsername, owner.getId(), weekStart);
        return schedule;
    }

    public VisibleScheduleRequestConstraints getVisibleScheduleRequestConstraints(IScheduleOwner owner, int weekStart) {
        VisibleScheduleRequestConstraints result = VisibleScheduleRequestConstraints.newInstance((IScheduleOwner)owner, (int)weekStart);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)result);
        }
        return result;
    }

    public CreateAppointmentFormBackingObject constructCreateAppointmentFormBackingObject(IScheduleOwner owner, Date startDateTime) throws SchedulingException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("enter constructCreateAppointmentFormBackingObject, start: " + startDateTime + ", owner: " + owner));
        }
        this.validateChosenStartTime(owner.getPreferredVisibleWindow(), startDateTime);
        AvailableBlock targetBlock = this.schedulingAssistantService.getTargetBlock(owner, startDateTime);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("getTargetBlock, startTime= " + startDateTime + " returns " + targetBlock));
        }
        if (targetBlock == null) {
            throw new SchedulingException("requested time is not available");
        }
        CreateAppointmentFormBackingObject fbo = new CreateAppointmentFormBackingObject(targetBlock, owner.getPreferredMeetingDurations());
        return fbo;
    }

    public VEvent createAppointment(CreateAppointmentFormBackingObject fbo, IScheduleOwner owner) throws SchedulingException {
        String visitorUsername = this.getCurrentVisitorUsername();
        AvailableBlock targetBlock = fbo.getTargetBlock();
        this.validateChosenStartTime(owner.getPreferredVisibleWindow(), targetBlock.getStartTime());
        if (fbo.isDoubleLengthAvailable()) {
            this.LOG.debug((Object)"entering doubleLengthAvailable test");
            if (fbo.getSelectedDuration() == fbo.getMeetingDurations().getMaxLength()) {
                this.LOG.debug((Object)"selected duration matches double length");
                targetBlock = this.schedulingAssistantService.getTargetDoubleLengthBlock(owner, targetBlock.getStartTime());
                if (targetBlock == null) {
                    throw new SchedulingException("second half of request time is not available");
                }
            }
        }
        VEvent event = this.schedulingAssistantService.scheduleAppointment(visitorUsername, owner.getId(), targetBlock, fbo.getReason());
        return event;
    }

    protected void validateChosenStartTime(VisibleWindow window, Date startTime) throws SchedulingException {
        if (startTime.before(window.calculateCurrentWindowStart()) || startTime.after(window.calculateCurrentWindowEnd())) {
            throw new SchedulingException("requested time is no longer within visible window");
        }
    }

    public CancelAppointmentFormBackingObject constructCancelAppointmentFormBackingObject(IScheduleOwner owner, Date startTime, Date endTime) throws SchedulingException {
        AvailableBlock targetBlock;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("enter constructCancelAppointmentFormBackingObject, start: " + startTime + ", end: " + endTime + " owner: " + owner));
        }
        if (null == (targetBlock = this.schedulingAssistantService.getTargetBlock(owner, startTime))) {
            throw new SchedulingException("requested time is not available in schedule");
        }
        if (!targetBlock.getEndTime().equals(endTime)) {
            targetBlock = this.schedulingAssistantService.getTargetDoubleLengthBlock(owner, startTime);
            if (null != targetBlock && targetBlock.getEndTime().equals(endTime)) {
                CancelAppointmentFormBackingObject fbo = new CancelAppointmentFormBackingObject(targetBlock);
                return fbo;
            }
            throw new SchedulingException("requested time is not available in schedule");
        }
        CancelAppointmentFormBackingObject fbo = new CancelAppointmentFormBackingObject(targetBlock);
        return fbo;
    }

    public EventCancellation cancelAppointment(CancelAppointmentFormBackingObject fbo, IScheduleOwner owner) throws SchedulingException {
        String visitorUsername = this.getCurrentVisitorUsername();
        EventCancellation result = this.schedulingAssistantService.cancelAppointment(visitorUsername, owner.getId(), fbo.getTargetBlock(), fbo.getReason());
        return result;
    }

    protected int safeConvertWeekStartParam(String weekStartParam) {
        try {
            int result = Integer.parseInt(weekStartParam);
            if (result < 1) {
                return 0;
            }
            return result;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

