/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.portlet;

import java.util.ArrayList;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Location;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.ConflictExistsException;
import org.jasig.schedassist.NoAppointmentExistsException;
import org.jasig.schedassist.SchedulingException;
import org.jasig.schedassist.messaging.AvailableBlockElement;
import org.jasig.schedassist.messaging.AvailableStatusType;
import org.jasig.schedassist.messaging.CancelAppointmentRequest;
import org.jasig.schedassist.messaging.CancelAppointmentResponse;
import org.jasig.schedassist.messaging.CreateAppointmentRequest;
import org.jasig.schedassist.messaging.CreateAppointmentResponse;
import org.jasig.schedassist.messaging.GetRelationshipsRequest;
import org.jasig.schedassist.messaging.GetRelationshipsResponse;
import org.jasig.schedassist.messaging.GetTargetAvailableBlockRequest;
import org.jasig.schedassist.messaging.GetTargetAvailableBlockResponse;
import org.jasig.schedassist.messaging.IsEligibleRequest;
import org.jasig.schedassist.messaging.IsEligibleResponse;
import org.jasig.schedassist.messaging.RelationshipElement;
import org.jasig.schedassist.messaging.ScheduleOwnerElement;
import org.jasig.schedassist.messaging.VisibleScheduleRequest;
import org.jasig.schedassist.messaging.VisibleScheduleResponse;
import org.jasig.schedassist.messaging.VisitorConflictsRequest;
import org.jasig.schedassist.messaging.VisitorConflictsResponse;
import org.jasig.schedassist.messaging.XMLDataUtils;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.AvailableBlockBuilder;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.MeetingDurations;
import org.jasig.schedassist.model.Relationship;
import org.jasig.schedassist.model.VisibleSchedule;
import org.jasig.schedassist.portlet.EventCancellation;
import org.jasig.schedassist.portlet.PortletScheduleOwnerImpl;
import org.jasig.schedassist.portlet.PortletSchedulingAssistantService;
import org.jasig.schedassist.portlet.WebServicesDaoSupport;
import org.springframework.ws.soap.client.SoapFaultClientException;

public final class PortletSchedulingAssistantServiceImpl
extends WebServicesDaoSupport
implements PortletSchedulingAssistantService {
    private Log LOG = LogFactory.getLog(this.getClass());
    public static final String CONFLICT_MESSAGE = "conflict exists";
    public static final String TIME_NOT_AVAILABLE_MESSAGE = "time not available";
    public static final String CANCEL_FAILED_MESSAGE = "Appointment no longer exists";

    @Override
    public boolean isEligible(String visitorUsername) {
        IsEligibleRequest request = new IsEligibleRequest();
        request.setVisitorNetid(visitorUsername);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("sending isEligible request for " + visitorUsername));
        }
        IsEligibleResponse response = (IsEligibleResponse)this.doSendAndReceive(request);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("isEligible for " + visitorUsername + " returns " + response.isEligible()));
        }
        return response.isEligible();
    }

    @Override
    public EventCancellation cancelAppointment(String visitorUsername, long ownerId, AvailableBlock block, String cancelReason) throws SchedulingException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("sending cancelAppointment request, visitor: " + visitorUsername + ", owner: " + ownerId + ", block: " + block));
        }
        CancelAppointmentRequest request = new CancelAppointmentRequest();
        request.setEndTime(XMLDataUtils.convertDateToXMLGregorianCalendar((java.util.Date)block.getEndTime()));
        request.setOwnerId(ownerId);
        request.setStartTime(XMLDataUtils.convertDateToXMLGregorianCalendar((java.util.Date)block.getStartTime()));
        request.setVisitorNetid(visitorUsername);
        request.setReason(cancelReason);
        try {
            CancelAppointmentResponse response = (CancelAppointmentResponse)this.doSendAndReceive(request);
            this.LOG.debug((Object)"cancelAppointment success");
            EventCancellation result = new EventCancellation(XMLDataUtils.convertXMLGregorianCalendarToDate((XMLGregorianCalendar)response.getStartTime()), XMLDataUtils.convertXMLGregorianCalendarToDate((XMLGregorianCalendar)response.getEndTime()));
            return result;
        }
        catch (SoapFaultClientException e) {
            if (CANCEL_FAILED_MESSAGE.equals(e.getFaultStringOrReason())) {
                this.LOG.info((Object)("cancelAppointment request for visitor " + visitorUsername + " and owner " + ownerId + " failed since appointment no longer exists"));
                throw new NoAppointmentExistsException(CANCEL_FAILED_MESSAGE, (Throwable)e);
            }
            this.LOG.error((Object)("cancelAppointment request for visitor " + visitorUsername + " and owner " + ownerId + " failed with SoapFaultClientException"), (Throwable)e);
            throw new SchedulingException((Throwable)e);
        }
    }

    @Override
    public VisibleSchedule getVisibleSchedule(String visitorUsername, long ownerId) {
        return this.getVisibleSchedule(visitorUsername, ownerId, 1);
    }

    @Override
    public VisibleSchedule getVisibleSchedule(String visitorUsername, long ownerId, int weekStart) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("sending getVisibleSchedule request, visitor: " + visitorUsername + ", owner: " + ownerId));
        }
        VisibleScheduleRequest request = new VisibleScheduleRequest();
        request.setOwnerId(ownerId);
        request.setVisitorNetid(visitorUsername);
        request.setWeekStart(weekStart);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)request);
        }
        VisibleScheduleResponse response = (VisibleScheduleResponse)this.doSendAndReceive(request);
        MeetingDurations durations = MeetingDurations.fromKey((String)response.getOwnerMeetingDurationsPreference().getValue());
        VisibleSchedule result = new VisibleSchedule(durations);
        List blockElements = response.getAvailableBlockList().getAvailableBlockElement();
        for (AvailableBlockElement blockElement : blockElements) {
            AvailableStatusType status = blockElement.getStatus();
            AvailableBlock block = AvailableBlockBuilder.createBlock((java.util.Date)blockElement.getStartTime().toGregorianCalendar().getTime(), (java.util.Date)blockElement.getEndTime().toGregorianCalendar().getTime(), (int)blockElement.getVisitorLimit());
            block.setVisitorsAttending(blockElement.getVisitorsAttending());
            result.addFreeBlock(block);
            switch (status) {
                case ATTENDING: {
                    result.setAttendingBlock(block);
                    break;
                }
                case BUSY: {
                    result.setBusyBlock(block);
                }
            }
        }
        return result;
    }

    @Override
    public List<AvailableBlock> calculateVisitorConflicts(String visitorUsername, long ownerId, int weekStart) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("calculateVisitorConflicts, visitor: " + visitorUsername + ", owner: " + ownerId));
        }
        VisitorConflictsRequest request = new VisitorConflictsRequest();
        request.setOwnerId(ownerId);
        request.setVisitorNetid(visitorUsername);
        request.setWeekStart(Integer.valueOf(weekStart));
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)request);
        }
        VisitorConflictsResponse response = (VisitorConflictsResponse)this.doSendAndReceive(request);
        List blockElements = response.getAvailableBlockList().getAvailableBlockElement();
        ArrayList<AvailableBlock> results = new ArrayList<AvailableBlock>();
        for (AvailableBlockElement blockElement : blockElements) {
            AvailableBlock block = AvailableBlockBuilder.createBlock((java.util.Date)blockElement.getStartTime().toGregorianCalendar().getTime(), (java.util.Date)blockElement.getEndTime().toGregorianCalendar().getTime());
            results.add(block);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("calculateVisitorConflicts result has " + results.size() + " elements"));
        }
        return results;
    }

    @Override
    public AvailableBlock getTargetBlock(IScheduleOwner owner, java.util.Date startTime) {
        return this.getTargetBlockInternal(owner, startTime, false);
    }

    @Override
    public AvailableBlock getTargetDoubleLengthBlock(IScheduleOwner owner, java.util.Date startTime) {
        return this.getTargetBlockInternal(owner, startTime, true);
    }

    protected AvailableBlock getTargetBlockInternal(IScheduleOwner owner, java.util.Date startTime, boolean doubleLength) {
        GetTargetAvailableBlockRequest request = new GetTargetAvailableBlockRequest();
        request.setOwnerId(owner.getId());
        request.setDoubleLength(doubleLength);
        request.setStartTime(XMLDataUtils.convertDateToXMLGregorianCalendar((java.util.Date)startTime));
        GetTargetAvailableBlockResponse response = (GetTargetAvailableBlockResponse)this.doSendAndReceive(request);
        if (null == response.getAvailableBlockElement()) {
            return null;
        }
        AvailableBlock result = PortletSchedulingAssistantServiceImpl.convertAvailableBlockElement(response.getAvailableBlockElement());
        return result;
    }

    @Override
    public VEvent scheduleAppointment(String visitorUsername, long ownerId, AvailableBlock block, String eventDescription) throws SchedulingException {
        this.LOG.debug((Object)("scheduleAppointment called; visitor: " + visitorUsername + ", owner: " + ownerId + ", block: " + block));
        CreateAppointmentRequest request = new CreateAppointmentRequest();
        request.setSelectedDuration(block.getDurationInMinutes());
        request.setEventDescription(eventDescription);
        request.setOwnerId(ownerId);
        request.setStartTime(XMLDataUtils.convertDateToXMLGregorianCalendar((java.util.Date)block.getStartTime()));
        request.setVisitorNetid(visitorUsername);
        try {
            CreateAppointmentResponse response = (CreateAppointmentResponse)this.doSendAndReceive(request);
            if (null == response) {
                this.LOG.error((Object)"response was null!");
            }
            this.LOG.debug((Object)("received response; start: " + response.getStartTime() + ", end: " + response.getEndTime() + ", location: " + response.getEventLocation() + ", title: " + response.getEventTitle()));
            VEvent vevent = new VEvent((Date)new DateTime(response.getStartTime().toGregorianCalendar().getTime()), (Date)new DateTime(response.getEndTime().toGregorianCalendar().getTime()), response.getEventTitle());
            Location location = new Location(response.getEventLocation());
            vevent.getProperties().add((Property)location);
            this.LOG.debug((Object)"scheduleAppointment success");
            return vevent;
        }
        catch (SoapFaultClientException e) {
            this.LOG.error((Object)"caught SOAP Fault in scheduleAppointment: ", (Throwable)e);
            if (e.getFaultStringOrReason().contains(CONFLICT_MESSAGE) || e.getFaultStringOrReason().contains(TIME_NOT_AVAILABLE_MESSAGE)) {
                throw new ConflictExistsException("a conflict exists for " + block, (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public List<Relationship> relationshipsForVisitor(String visitorUsername) {
        this.LOG.debug((Object)("relationshipsForVisitor, visitor: " + visitorUsername));
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        GetRelationshipsRequest request = new GetRelationshipsRequest();
        request.setVisitorNetid(visitorUsername);
        GetRelationshipsResponse response = (GetRelationshipsResponse)this.doSendAndReceive(request);
        this.LOG.debug((Object)"getRelationships response received");
        List relationshipElements = response.getRelationshipList().getRelationshipElement();
        this.LOG.debug((Object)("getRelationships response received with size " + relationshipElements.size()));
        for (RelationshipElement relationshipElement : relationshipElements) {
            IScheduleOwner owner = PortletSchedulingAssistantServiceImpl.convertOwnerElement(relationshipElement.getScheduleOwnerElement());
            this.LOG.debug((Object)("-> " + visitorUsername + ", " + owner.getCalendarAccount().getUsername()));
            Relationship relationship = new Relationship();
            relationship.setDescription(relationshipElement.getDescription());
            relationship.setOwner(owner);
            result.add(relationship);
        }
        return result;
    }

    protected static IScheduleOwner convertOwnerElement(ScheduleOwnerElement element) {
        PortletScheduleOwnerImpl owner = new PortletScheduleOwnerImpl(element);
        return owner;
    }

    protected static AvailableBlock convertAvailableBlockElement(AvailableBlockElement element) {
        java.util.Date startTime = XMLDataUtils.convertXMLGregorianCalendarToDate((XMLGregorianCalendar)element.getStartTime());
        java.util.Date endTime = XMLDataUtils.convertXMLGregorianCalendarToDate((XMLGregorianCalendar)element.getEndTime());
        AvailableBlock result = AvailableBlockBuilder.createBlock((java.util.Date)startTime, (java.util.Date)endTime, (int)element.getVisitorLimit());
        result.setVisitorsAttending(element.getVisitorsAttending());
        return result;
    }
}

