/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.portlet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.portlet.IneligibleForServiceException;
import org.jasig.schedassist.portlet.ServiceUnavailableException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.client.SoapFaultClientException;

public abstract class WebServicesDaoSupport {
    public static final String INELIGIBLE_MESSAGE = "User not eligible for Schedule Visitor role";
    public static final String SERVICE_UNAVAILABLE_MESSAGE = "Service Unavailable";
    private Log LOG = LogFactory.getLog(this.getClass());
    private WebServiceTemplate webServiceTemplate;

    @Required
    public void setWebServiceTemplate(WebServiceTemplate webServiceTemplate) {
        this.webServiceTemplate = webServiceTemplate;
    }

    protected Object doSendAndReceive(Object request) {
        try {
            this.LOG.debug((Object)"enter doSendAndReceive");
            Object result = this.webServiceTemplate.marshalSendAndReceive(request);
            this.LOG.debug((Object)"exit doSendAndReceive");
            return result;
        }
        catch (SoapFaultClientException e) {
            this.LOG.debug((Object)("caught exception in doSendAndReceive on " + request), (Throwable)e);
            String faultString = e.getFaultStringOrReason();
            if (faultString != null) {
                if (faultString.contains(INELIGIBLE_MESSAGE)) {
                    throw new IneligibleForServiceException(e);
                }
                if (faultString.contains(SERVICE_UNAVAILABLE_MESSAGE)) {
                    this.LOG.warn((Object)("exception faultString translates to ServiceUnavailableExcpetion for " + request), (Throwable)e);
                    throw new ServiceUnavailableException(e);
                }
            }
            throw e;
        }
    }
}

