/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.portlet;

import java.util.HashMap;
import java.util.Map;
import org.jasig.schedassist.messaging.PreferencesElement;
import org.jasig.schedassist.messaging.ScheduleOwnerElement;
import org.jasig.schedassist.model.AbstractScheduleOwner;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.Preferences;
import org.jasig.schedassist.portlet.PortletScheduleOwnerImpl;

class PortletScheduleOwnerImpl
extends AbstractScheduleOwner {
    private static final long serialVersionUID = 53706L;
    private final long id;
    private final Map<Preferences, String> preferences;

    PortletScheduleOwnerImpl(ScheduleOwnerElement element) {
        super((ICalendarAccount)new CalendarAccountImpl(element));
        this.id = element.getId();
        HashMap<Preferences, String> prefs = new HashMap<Preferences, String>();
        for (PreferencesElement prefElement : element.getPreferencesSet().getPreferencesElement()) {
            Preferences pref = Preferences.fromKey((String)prefElement.getKey());
            if (pref == null) continue;
            prefs.put(pref, prefElement.getValue());
        }
        this.preferences = prefs;
    }

    public long getId() {
        return this.id;
    }

    public String getPreference(Preferences preference) {
        return (String)this.preferences.get(preference);
    }

    public Map<Preferences, String> getPreferences() {
        return new HashMap<Preferences, String>(this.preferences);
    }

    public String toString() {
        return "PortletScheduleOwnerImpl [id=" + this.id + ", toString()=" + super.toString() + "]";
    }
}

