/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.caldav;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Resource;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.caldav.CaldavDialect;
import org.jasig.schedassist.impl.caldav.CalendarWithURI;
import org.jasig.schedassist.model.ICalendarAccount;

public class DefaultCaldavDialectImpl
implements CaldavDialect {
    protected static final String DATE_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    protected static final ProdId PROD_ID = new ProdId("-//jasig.org//Jasig Scheduling Assistant 1.0//EN");
    private URI caldavHost;
    private String accountHomePrefix = "/ucaldav/user/";
    private String accountHomeSuffix = "/calendar/";
    private Log log = LogFactory.getLog(this.getClass());

    public String getAccountHomePrefix() {
        return this.accountHomePrefix;
    }

    public void setAccountHomePrefix(String accountHomePrefix) {
        this.accountHomePrefix = accountHomePrefix;
    }

    public String getAccountHomeSuffix() {
        return this.accountHomeSuffix;
    }

    public void setAccountHomeSuffix(String accountHomeSuffix) {
        this.accountHomeSuffix = accountHomeSuffix;
    }

    @Override
    public URI getCaldavHost() {
        return this.caldavHost;
    }

    @Resource
    public void setCaldavHost(URI caldavHost) {
        this.caldavHost = caldavHost;
    }

    @Override
    public RequestEntity generateGetCalendarRequestEntity(Date startDate, Date endDate) {
        String content = this.generateGetCalendarRequestXML(startDate, endDate);
        try {
            StringRequestEntity requestEntity = new StringRequestEntity(content, "text/xml", "UTF-8");
            return requestEntity;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String generateGetCalendarRequestXML(Date startDate, Date endDate) {
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        content.append("<C:calendar-query xmlns:D=\"DAV:\" xmlns:C=\"urn:ietf:params:xml:ns:caldav\">");
        content.append("  <D:prop>");
        content.append("    <D:getetag/>");
        content.append("    <C:calendar-data/>");
        content.append("  </D:prop>");
        content.append("  <C:filter>");
        content.append("    <C:comp-filter name=\"VCALENDAR\">");
        content.append("      <C:comp-filter name=\"VEVENT\">");
        content.append("        <C:time-range start=\"" + this.formatDateTime(startDate) + "\" end=\"" + this.formatDateTime(endDate) + "\"/>");
        content.append("      </C:comp-filter>");
        content.append("    </C:comp-filter>");
        content.append("  </C:filter>");
        content.append("</C:calendar-query>");
        String result = content.toString();
        this.log.debug((Object)result);
        return result;
    }

    @Override
    public RequestEntity generatePutAppointmentRequestEntity(VEvent event) {
        try {
            StringRequestEntity requestEntity = new StringRequestEntity(this.wrapEventInCalendar(event).toString(), "text/calendar", "UTF-8");
            return requestEntity;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getCalendarAccountHome(ICalendarAccount calendarAccount) {
        Validate.notNull((Object)calendarAccount, (String)"calendarAccount argument must not be null");
        String accountUsername = calendarAccount.getUsername();
        Validate.notNull((Object)accountUsername, (String)"username in calendarAccount argument must not be null");
        StringBuilder uri = new StringBuilder();
        uri.append(this.getCaldavHost().toString());
        uri.append(this.getAccountHomePrefix());
        uri.append(accountUsername);
        uri.append(this.getAccountHomeSuffix());
        return uri.toString();
    }

    @Override
    public URI resolveCalendarURI(CalendarWithURI calendar) {
        Validate.notNull((Object)calendar, (String)"CalendarWithURI argument cannot be null");
        StringBuilder result = new StringBuilder();
        result.append(this.caldavHost.toString());
        result.append(calendar.getUri());
        try {
            URI uri = new URI(result.toString());
            return uri;
        }
        catch (URISyntaxException e) {
            this.log.error((Object)("cannot construct uri from " + result.toString()), (Throwable)e);
            throw new IllegalStateException("cannot construct uri from " + result.toString(), e);
        }
    }

    protected String formatDateTime(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(date);
    }

    protected Calendar wrapEventInCalendar(VEvent event) {
        ComponentList components = new ComponentList();
        components.add((Component)event);
        Calendar result = new Calendar(components);
        result.getProperties().add((Property)Version.VERSION_2_0);
        result.getProperties().add((Property)PROD_ID);
        return result;
    }
}

