/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.caldav;

import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Transp;
import org.jasig.schedassist.IAffiliationSource;
import org.jasig.schedassist.model.AppointmentRole;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.DefaultEventUtilsImpl;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;

public class CaldavEventUtilsImpl
extends DefaultEventUtilsImpl {
    public CaldavEventUtilsImpl(IAffiliationSource affiliationSource) {
        super(affiliationSource);
    }

    public VEvent constructAvailableAppointment(AvailableBlock block, IScheduleOwner owner, IScheduleVisitor visitor, String eventDescription) {
        VEvent event = super.constructAvailableAppointment(block, owner, visitor, eventDescription);
        event.getProperties().add((Property)this.constructOrganizer(owner.getCalendarAccount()));
        event.getProperties().add((Property)this.generateNewUid());
        return event;
    }

    public Organizer constructOrganizer(ICalendarAccount calendarAccount) {
        ParameterList parameterList = new ParameterList();
        parameterList.add((Parameter)new Cn(calendarAccount.getDisplayName()));
        Organizer organizer = new Organizer(parameterList, CaldavEventUtilsImpl.emailToURI((String)calendarAccount.getEmailAddress()));
        return organizer;
    }

    public boolean willEventCauseConflict(ICalendarAccount calendarAccount, VEvent event) {
        if (event == null) {
            return false;
        }
        Status status = event.getStatus();
        if (status != null && Status.VEVENT_CANCELLED.equals((Object)status)) {
            return false;
        }
        Transp transp = event.getTransparency();
        if (null == transp) {
            return true;
        }
        return Transp.OPAQUE.equals((Object)transp);
    }

    public Attendee constructAvailableAttendee(ICalendarAccount calendarAccount, AppointmentRole role) {
        Attendee attendee = super.constructAvailableAttendee(calendarAccount, role);
        if (AppointmentRole.OWNER.equals((Object)role)) {
            attendee.getParameters().add((Parameter)Role.CHAIR);
        } else if (AppointmentRole.VISITOR.equals((Object)role)) {
            attendee.getParameters().add((Parameter)Role.REQ_PARTICIPANT);
        }
        return attendee;
    }

    protected VEvent convertBlockToReflectionEvent(AvailableBlock block) {
        VEvent reflection = super.convertBlockToReflectionEvent(block);
        reflection.getProperties().add((Property)this.generateNewUid());
        return reflection;
    }
}

