/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.caldav;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.Calendars;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.ConflictExistsException;
import org.jasig.schedassist.IAffiliationSource;
import org.jasig.schedassist.ICalendarDataDao;
import org.jasig.schedassist.NullAffiliationSourceImpl;
import org.jasig.schedassist.SchedulingException;
import org.jasig.schedassist.impl.caldav.CaldavDataAccessException;
import org.jasig.schedassist.impl.caldav.CaldavDialect;
import org.jasig.schedassist.impl.caldav.CaldavEventUtilsImpl;
import org.jasig.schedassist.impl.caldav.CalendarWithURI;
import org.jasig.schedassist.impl.caldav.HttpMethodInterceptor;
import org.jasig.schedassist.impl.caldav.NoopHttpMethodInterceptorImpl;
import org.jasig.schedassist.impl.caldav.ReportMethod;
import org.jasig.schedassist.impl.caldav.xml.ReportResponseHandlerImpl;
import org.jasig.schedassist.impl.events.AutomaticAppointmentCancellationEvent;
import org.jasig.schedassist.impl.events.AutomaticAttendeeRemovalEvent;
import org.jasig.schedassist.model.AppointmentRole;
import org.jasig.schedassist.model.AvailabilityReflection;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.AvailableSchedule;
import org.jasig.schedassist.model.AvailableVersion;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IEventUtils;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.SchedulingAssistantAppointment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class CaldavCalendarDataDaoImpl
implements ICalendarDataDao,
InitializingBean {
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final Header IF_NONE_MATCH_HEADER = new Header("If-None-Match", "*");
    private static final Header ICALENDAR_CONTENT_TYPE_HEADER = new Header("Content-Type", "text/calendar");
    private static final String IF_MATCH_HEADER = "If-Match";
    private static final Header DEPTH_HEADER = new Header("Depth", "1");
    protected final Log log = LogFactory.getLog(this.getClass());
    private HttpClient httpClient;
    private Credentials caldavAdminCredentials;
    private AuthScope caldavAdminAuthScope;
    private IEventUtils eventUtils = new CaldavEventUtilsImpl((IAffiliationSource)new NullAffiliationSourceImpl());
    private CaldavDialect caldavDialect;
    private HttpMethodInterceptor methodInterceptor = new NoopHttpMethodInterceptorImpl();
    private boolean cancelUpdatesVisitorCalendar = false;
    private final boolean reflectionEnabled = Boolean.parseBoolean(System.getProperty("org.jasig.schedassist.impl.caldav.reflectionEnabled", "false"));
    private ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Autowired
    public void setCaldavAdminCredentials(Credentials caldavAdminCredentials) {
        this.caldavAdminCredentials = caldavAdminCredentials;
    }

    @Autowired
    public void setCaldavAdminAuthScope(AuthScope caldavAdminAuthScope) {
        this.caldavAdminAuthScope = caldavAdminAuthScope;
    }

    @Autowired(required=false)
    public void setEventUtils(IEventUtils eventUtils) {
        this.eventUtils = eventUtils;
    }

    @Autowired
    public void setCaldavDialect(CaldavDialect caldavDialect) {
        this.caldavDialect = caldavDialect;
    }

    @Autowired(required=false)
    public void setMethodInterceptor(HttpMethodInterceptor methodInterceptor) {
        this.methodInterceptor = methodInterceptor;
    }

    @Autowired
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Value(value="${caldav.cancelUpdatesVisitorCalendar}")
    public void setCancelUpdatesVisitorCalendar(String cancelUpdatesVisitorCalendar) {
        this.cancelUpdatesVisitorCalendar = Boolean.parseBoolean(cancelUpdatesVisitorCalendar);
    }

    public void afterPropertiesSet() throws Exception {
        this.httpClient.getState().setCredentials(this.caldavAdminAuthScope, this.caldavAdminCredentials);
    }

    public Calendar getCalendar(ICalendarAccount calendarAccount, java.util.Date startDate, java.util.Date endDate) {
        List<CalendarWithURI> calendars = this.getCalendarsInternal(calendarAccount, startDate, endDate);
        Calendar result = this.consolidate(calendars);
        return result;
    }

    public VEvent getExistingAppointment(IScheduleOwner owner, AvailableBlock block) {
        CalendarWithURI calendarWithUri = this.getExistingAppointmentInternal(owner, block.getStartTime(), block.getEndTime());
        if (null != calendarWithUri) {
            ComponentList componentList = calendarWithUri.getCalendar().getComponents("VEVENT");
            return (VEvent)componentList.get(0);
        }
        return null;
    }

    public VEvent createAppointment(IScheduleVisitor visitor, IScheduleOwner owner, AvailableBlock block, String eventDescription) {
        VEvent event = this.eventUtils.constructAvailableAppointment(block, owner, visitor, eventDescription);
        try {
            int statusCode = this.putNewEvent(owner.getCalendarAccount(), event);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("createAppointment status code: " + statusCode));
            }
            if (statusCode == 200 || statusCode == 201) {
                return event;
            }
            throw new CaldavDataAccessException("createAppointment for " + visitor + ", " + owner + ", " + block + " failed with unexpected status code: " + statusCode);
        }
        catch (HttpException e) {
            this.log.error((Object)("an HttpException occurred in createAppointment for " + owner + ", " + visitor + ", " + block));
            throw new CaldavDataAccessException(e);
        }
        catch (IOException e) {
            this.log.error((Object)("an IOException occurred in createAppointment for " + owner + ", " + visitor + ", " + block));
            throw new CaldavDataAccessException(e);
        }
    }

    public void cancelAppointment(IScheduleVisitor visitor, IScheduleOwner owner, VEvent appointment) {
        Date endTime;
        Date startTime = appointment.getStartDate().getDate();
        CalendarWithURI calendarWithURI = this.getExistingAppointmentInternal(owner, (java.util.Date)startTime, (java.util.Date)(endTime = appointment.getEndDate(true).getDate()));
        if (null != calendarWithURI) {
            VEvent event = this.extractSchedulingAssistantAppointment(calendarWithURI);
            Uid eventUid = event.getUid();
            int status = this.deleteCalendar(calendarWithURI, owner.getCalendarAccount());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("cancelAppointment status code " + status + " for " + owner + ", " + eventUid));
            }
            if (this.cancelUpdatesVisitorCalendar) {
                CalendarWithURI visitorCalendarWithURI = this.getExistingAppointmentInternalForVisitor(visitor, (java.util.Date)startTime, (java.util.Date)endTime, eventUid);
                if (visitorCalendarWithURI != null) {
                    status = this.deleteCalendar(visitorCalendarWithURI, visitor.getCalendarAccount());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("cancelAppointment status code " + status + " for " + visitor + ", " + eventUid));
                    }
                } else {
                    this.log.warn((Object)("cancelAppointment unable to locate event in schedule for visitor " + visitor + " with uid " + eventUid));
                }
            }
        } else {
            this.log.warn((Object)("cannot cancelAppointment for " + owner + ", no matching appointment found (" + appointment + ")"));
        }
    }

    protected int deleteCalendar(CalendarWithURI calendarWithURI, ICalendarAccount calendarAccount) {
        URI uri = this.caldavDialect.resolveCalendarURI(calendarWithURI);
        DeleteMethod method = new DeleteMethod(uri.toString());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("deleteCalendar executing " + this.methodToString((HttpMethod)method) + " for " + calendarAccount));
        }
        HttpMethod toExecute = this.methodInterceptor.doWithMethod((HttpMethod)method, calendarAccount);
        try {
            int statusCode = this.httpClient.executeMethod(toExecute);
            this.log.debug((Object)("deleteCalendar status code: " + statusCode));
            if (statusCode == 204) {
                return statusCode;
            }
            throw new CaldavDataAccessException("deleteCalendar for " + calendarAccount + ", " + calendarWithURI + " failed with unexpected status code: " + statusCode);
        }
        catch (HttpException e) {
            this.log.error((Object)("an HttpException occurred in deleteCalendar for " + calendarAccount + ", " + calendarWithURI));
            throw new CaldavDataAccessException(e);
        }
        catch (IOException e) {
            this.log.error((Object)("an IOException occurred in deleteCalendar for " + calendarAccount + ", " + calendarWithURI));
            throw new CaldavDataAccessException(e);
        }
    }

    public VEvent joinAppointment(IScheduleVisitor visitor, IScheduleOwner owner, VEvent appointment) throws SchedulingException {
        Date endTime;
        Date startTime = appointment.getStartDate().getDate();
        CalendarWithURI calendarWithURI = this.getExistingAppointmentInternal(owner, (java.util.Date)startTime, (java.util.Date)(endTime = appointment.getEndDate(true).getDate()));
        if (null != calendarWithURI) {
            VEvent event = this.extractSchedulingAssistantAppointment(calendarWithURI);
            Attendee attendee = this.eventUtils.constructAvailableAttendee(visitor.getCalendarAccount(), AppointmentRole.VISITOR);
            event.getProperties().add((Property)attendee);
            try {
                int statusCode = this.putExistingEvent(owner.getCalendarAccount(), event, calendarWithURI.getEtag());
                this.log.debug((Object)("joinAppointment status code: " + statusCode));
                if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
                    return event;
                }
                if (statusCode == 412) {
                    throw new SchedulingException("joinAppointment failed for " + visitor + " and " + owner + ", appointment was altered");
                }
                throw new CaldavDataAccessException("joinAppointment for " + visitor + ", " + owner + ", " + startTime + " failed with unexpected status code: " + statusCode);
            }
            catch (HttpException e) {
                this.log.error((Object)("an HttpException occurred in joinAppointment for " + owner + ", " + visitor + ", " + startTime));
                throw new CaldavDataAccessException(e);
            }
            catch (IOException e) {
                this.log.error((Object)("an IOException occurred in joinAppointment for " + owner + ", " + visitor + ", " + startTime));
                throw new CaldavDataAccessException(e);
            }
        }
        this.log.warn((Object)("cannot joinAppointment for " + owner + ", no matching appointment found (" + appointment + ")"));
        throw new SchedulingException("joinAppointment failed for " + visitor + " and " + owner + ", no matching appointment found");
    }

    public VEvent leaveAppointment(IScheduleVisitor visitor, IScheduleOwner owner, VEvent appointment) throws SchedulingException {
        Date endTime;
        Date startTime = appointment.getStartDate().getDate();
        CalendarWithURI calendarWithURI = this.getExistingAppointmentInternal(owner, (java.util.Date)startTime, (java.util.Date)(endTime = appointment.getEndDate(true).getDate()));
        if (null != calendarWithURI) {
            VEvent event = this.extractSchedulingAssistantAppointment(calendarWithURI);
            Uid eventUid = event.getUid();
            Property attendee = this.eventUtils.getAttendeeForUserFromEvent(event, visitor.getCalendarAccount());
            event.getProperties().remove(attendee);
            try {
                int statusCode = this.putExistingEvent(owner.getCalendarAccount(), event, calendarWithURI.getEtag());
                this.log.debug((Object)("leaveAppointment status code: " + statusCode));
                if (statusCode != 200 && statusCode != 201 && statusCode != 204) {
                    if (statusCode == 412) {
                        throw new SchedulingException("leaveAppointment failed for " + visitor + " and " + owner + ", appointment was altered");
                    }
                    throw new CaldavDataAccessException("leaveAppointment for " + visitor + ", " + owner + ", " + startTime + " failed with unexpected status code: " + statusCode);
                }
                this.log.debug((Object)"leaveAppointment owner calendar update successful");
            }
            catch (HttpException e) {
                this.log.error((Object)("an HttpException occurred in leaveAppointment for " + owner + ", " + visitor + ", " + startTime));
                throw new CaldavDataAccessException(e);
            }
            catch (IOException e) {
                this.log.error((Object)("an IOException occurred in leaveAppointment for " + owner + ", " + visitor + ", " + startTime));
                throw new CaldavDataAccessException(e);
            }
            if (this.cancelUpdatesVisitorCalendar) {
                CalendarWithURI visitorCalendarWithURI = this.getExistingAppointmentInternalForVisitor(visitor, (java.util.Date)startTime, (java.util.Date)endTime, eventUid);
                if (visitorCalendarWithURI != null) {
                    int status = this.deleteCalendar(visitorCalendarWithURI, visitor.getCalendarAccount());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("leaveAppointment status code " + status + " for " + visitor + ", " + eventUid));
                    }
                } else {
                    this.log.warn((Object)("leaveAppointment unable to locate event in schedule for visitor " + visitor + " with uid " + eventUid));
                }
            }
            return event;
        }
        this.log.warn((Object)("cannot leaveAppointment for " + owner + ", no matching appointment found (" + appointment + ")"));
        throw new SchedulingException("leaveAppointment failed for " + visitor + " and " + owner + ", no matching appointment found");
    }

    public void checkForConflicts(IScheduleOwner owner, AvailableBlock block) throws ConflictExistsException {
        List<CalendarWithURI> calendars = this.getCalendarsInternal(owner.getCalendarAccount(), block.getStartTime(), block.getEndTime());
        for (CalendarWithURI calendar : calendars) {
            ComponentList events = calendar.getCalendar().getComponents("VEVENT");
            for (Object component : events) {
                VEvent event = (VEvent)component;
                if (!this.eventUtils.willEventCauseConflict(owner.getCalendarAccount(), event)) continue;
                throw new ConflictExistsException("an appointment already exists for " + block);
            }
        }
    }

    public void reflectAvailableSchedule(IScheduleOwner owner, AvailableSchedule schedule) {
        if (this.reflectionEnabled) {
            if (schedule.isEmpty()) {
                return;
            }
            java.util.Date startDate = CommonDateOperations.beginningOfDay((java.util.Date)schedule.getScheduleStartTime());
            java.util.Date endDate = CommonDateOperations.endOfDay((java.util.Date)schedule.getScheduleEndTime());
            this.purgeAvailableScheduleReflections(owner, startDate, endDate);
            List calendars = this.eventUtils.convertScheduleForReflection(schedule);
            for (Calendar calendar : calendars) {
                ComponentList events = calendar.getComponents("VEVENT");
                Iterator i$ = events.iterator();
                if (!i$.hasNext()) continue;
                Object o = i$.next();
                VEvent reflect = (VEvent)o;
                try {
                    int statusCode = this.putNewEvent(owner.getCalendarAccount(), reflect);
                    if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
                        return;
                    }
                    throw new CaldavDataAccessException("reflectAvailableSchedule for " + owner + " failed with unexpected status code: " + statusCode);
                }
                catch (HttpException e) {
                    this.log.error((Object)("an HttpException occurred in reflectAvailableSchedule for " + owner));
                    throw new CaldavDataAccessException(e);
                }
                catch (IOException e) {
                    this.log.error((Object)("an IOException occurred in reflectAvailableSchedule for " + owner));
                    throw new CaldavDataAccessException(e);
                }
            }
        } else {
            this.log.debug((Object)"experimental feature 'Availability Schedule reflection' disabled by default");
        }
    }

    public void purgeAvailableScheduleReflections(IScheduleOwner owner, java.util.Date startDate, java.util.Date endDate) {
        if (this.reflectionEnabled) {
            List<CalendarWithURI> calendars = this.peekAtAvailableScheduleReflections(owner, startDate, endDate);
            Iterator<CalendarWithURI> i$ = calendars.iterator();
            if (i$.hasNext()) {
                CalendarWithURI calendar = i$.next();
                URI uri = this.caldavDialect.resolveCalendarURI(calendar);
                DeleteMethod method = new DeleteMethod(uri.toString());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("purgeAvailableScheduleReflections executing " + this.methodToString((HttpMethod)method) + " for " + owner + ", " + startDate + ", " + endDate));
                }
                HttpMethod toExecute = this.methodInterceptor.doWithMethod((HttpMethod)method, owner.getCalendarAccount());
                try {
                    int statusCode = this.httpClient.executeMethod(toExecute);
                    this.log.debug((Object)("cancelAppointment status code: " + statusCode));
                    if (statusCode == 204) {
                        return;
                    }
                    throw new CaldavDataAccessException("purgeAvailableScheduleReflections for " + owner + ", " + startDate + ", " + endDate + " failed with unexpected status code: " + statusCode);
                }
                catch (HttpException e) {
                    this.log.error((Object)("an HttpException occurred in purgeAvailableScheduleReflections for " + owner + ", " + startDate + ", " + endDate));
                    throw new CaldavDataAccessException(e);
                }
                catch (IOException e) {
                    this.log.error((Object)("an IOException occurred in purgeAvailableScheduleReflections for " + owner + ", " + startDate + ", " + endDate));
                    throw new CaldavDataAccessException(e);
                }
            }
        } else {
            this.log.debug((Object)"experimental feature 'Availability Schedule reflection' disabled");
        }
    }

    public List<CalendarWithURI> peekAtAvailableScheduleReflections(IScheduleOwner owner, java.util.Date startDate, java.util.Date endDate) {
        if (this.reflectionEnabled) {
            List<CalendarWithURI> calendars = this.getCalendarsInternal(owner.getCalendarAccount(), startDate, endDate);
            ArrayList<CalendarWithURI> results = new ArrayList<CalendarWithURI>();
            for (CalendarWithURI calendar : calendars) {
                ComponentList events = calendar.getCalendar().getComponents("VEVENT");
                for (Object component : events) {
                    VEvent event = (VEvent)component;
                    if (!event.getProperties().contains((Object)AvailabilityReflection.TRUE)) continue;
                    results.add(calendar);
                }
            }
            return results;
        }
        this.log.debug((Object)"experimental feature 'Availability Schedule reflection' disabled");
        return Collections.emptyList();
    }

    protected String generateEventUri(ICalendarAccount owner, VEvent event) {
        Validate.notNull((Object)event, (String)"event argument cannot be null");
        Validate.notNull((Object)event.getUid(), (String)"cannot generateEventUri for event with null UID");
        String accountHome = this.caldavDialect.getCalendarAccountHome(owner);
        StringBuilder eventUri = new StringBuilder(accountHome);
        eventUri.append(event.getUid().getValue());
        eventUri.append(".ics");
        return eventUri.toString();
    }

    protected List<CalendarWithURI> getCalendarsInternal(ICalendarAccount calendarAccount, java.util.Date startDate, java.util.Date endDate) {
        String accountUri = this.caldavDialect.getCalendarAccountHome(calendarAccount);
        RequestEntity requestEntity = this.caldavDialect.generateGetCalendarRequestEntity(startDate, endDate);
        ReportMethod method = new ReportMethod(accountUri);
        method.setRequestEntity(requestEntity);
        method.addRequestHeader(CONTENT_LENGTH_HEADER, Long.toString(requestEntity.getContentLength()));
        method.addRequestHeader(DEPTH_HEADER);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getCalendarsInternal executing " + this.methodToString((HttpMethod)method) + " for " + calendarAccount + ", start " + startDate + ", end " + endDate));
        }
        HttpMethod toExecute = this.methodInterceptor.doWithMethod((HttpMethod)method, calendarAccount);
        try {
            int statusCode = this.httpClient.executeMethod(toExecute);
            this.log.debug((Object)("getCalendarsInternal status code: " + statusCode));
            if (statusCode == 200 || statusCode == 207) {
                InputStream content = method.getResponseBodyAsStream();
                ReportResponseHandlerImpl reportResponseHandler = new ReportResponseHandlerImpl();
                List<CalendarWithURI> calendars = reportResponseHandler.extractCalendars(content);
                ArrayList<CalendarWithURI> results = new ArrayList<CalendarWithURI>();
                for (CalendarWithURI c : calendars) {
                    if (this.purgeDeclinedAttendees(c, calendarAccount) == null) continue;
                    results.add(c);
                }
                return results;
            }
            throw new CaldavDataAccessException("unexpected status code: " + statusCode);
        }
        catch (HttpException e) {
            this.log.error((Object)("an HttpException occurred in getCalendarsInternal for " + calendarAccount + ", " + startDate + ", " + endDate));
            throw new CaldavDataAccessException(e);
        }
        catch (IOException e) {
            this.log.error((Object)("an IOException occurred in getCalendarsInternal for " + calendarAccount + ", " + startDate + ", " + endDate));
            throw new CaldavDataAccessException(e);
        }
    }

    protected Calendar consolidate(List<CalendarWithURI> calendars) {
        int size = calendars.size();
        if (size == 0) {
            return new Calendar();
        }
        if (size == 1) {
            return calendars.get(0).getCalendar();
        }
        if (size == 2) {
            return Calendars.merge((Calendar)calendars.get(0).getCalendar(), (Calendar)calendars.get(1).getCalendar());
        }
        Calendar main = Calendars.merge((Calendar)calendars.get(0).getCalendar(), (Calendar)calendars.get(1).getCalendar());
        for (int i = 2; i < size; ++i) {
            main = Calendars.merge((Calendar)main, (Calendar)calendars.get(i).getCalendar());
        }
        return main;
    }

    protected CalendarWithURI getExistingAppointmentInternal(IScheduleOwner owner, java.util.Date startTime, java.util.Date endTime) {
        DateTime targetStartTime = new DateTime(startTime);
        DateTime targetEndTime = new DateTime(endTime);
        List<CalendarWithURI> calendars = this.getCalendarsInternal(owner.getCalendarAccount(), startTime, endTime);
        for (CalendarWithURI calendarWithUri : calendars) {
            ComponentList componentList = calendarWithUri.getCalendar().getComponents("VEVENT");
            if (componentList.size() != 1) continue;
            for (Object o : componentList) {
                Property versionProperty;
                VEvent event = (VEvent)o;
                Date eventStart = event.getStartDate().getDate();
                Date eventEnd = event.getEndDate(true).getDate();
                Property schedAssistProperty = event.getProperty("X-UW-AVAILABLE-APPOINTMENT");
                if (!SchedulingAssistantAppointment.TRUE.equals((Object)schedAssistProperty) || !AvailableVersion.AVAILABLE_VERSION_1_2.equals((Object)(versionProperty = event.getProperty("X-UW-AVAILABLE-VERSION")))) continue;
                Parameter ownerAttendeeRole = null;
                Property ownerAttendee = this.eventUtils.getAttendeeForUserFromEvent(event, owner.getCalendarAccount());
                if (ownerAttendee != null) {
                    ownerAttendeeRole = ownerAttendee.getParameter("X-UW-AVAILABLE-APPOINTMENT-ROLE");
                }
                if (null == ownerAttendeeRole || !AppointmentRole.OWNER.equals((Object)ownerAttendeeRole) || !eventStart.equals(targetStartTime) || !eventEnd.equals(targetEndTime)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("getExistingAppointmentInternal found " + event));
                }
                return calendarWithUri;
            }
        }
        return null;
    }

    protected CalendarWithURI getExistingAppointmentInternalForVisitor(IScheduleVisitor visitor, java.util.Date startTime, java.util.Date endTime, Uid eventUid) {
        DateTime targetStartTime = new DateTime(startTime);
        DateTime targetEndTime = new DateTime(endTime);
        if (eventUid == null) {
            this.log.debug((Object)("cannot call getExistingAppointmentInternal with null eventUid, visitor: " + visitor));
            return null;
        }
        List<CalendarWithURI> calendars = this.getCalendarsInternal(visitor.getCalendarAccount(), startTime, endTime);
        for (CalendarWithURI calendarWithUri : calendars) {
            ComponentList componentList = calendarWithUri.getCalendar().getComponents("VEVENT");
            if (componentList.size() != 1) continue;
            for (Object o : componentList) {
                VEvent event = (VEvent)o;
                Date eventStart = event.getStartDate().getDate();
                Date eventEnd = event.getEndDate(true).getDate();
                Uid uid = event.getUid();
                if (uid == null || !eventUid.equals((Object)uid) || !Status.VEVENT_CANCELLED.equals((Object)event.getStatus()) || !eventStart.equals(targetStartTime) || !eventEnd.equals(targetEndTime)) continue;
                return calendarWithUri;
            }
        }
        return null;
    }

    protected int putNewEvent(ICalendarAccount eventOwner, VEvent event) throws HttpException, IOException {
        String uri = this.generateEventUri(eventOwner, event);
        PutMethod method = this.constructPutMethod(uri, event);
        method.addRequestHeader(IF_NONE_MATCH_HEADER);
        HttpMethod toExecute = this.methodInterceptor.doWithMethod((HttpMethod)method, eventOwner);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("putNewEvent executing " + this.methodToString((HttpMethod)method) + " for " + eventOwner));
        }
        int statusCode = this.httpClient.executeMethod(toExecute);
        if (this.log.isDebugEnabled()) {
            InputStream content = method.getResponseBodyAsStream();
            this.log.debug((Object)("putNewEvent response body: " + IOUtils.toString((InputStream)content)));
        }
        return statusCode;
    }

    protected int putExistingEvent(ICalendarAccount eventOwner, VEvent event, String etag) throws HttpException, IOException {
        String uri = this.generateEventUri(eventOwner, event);
        PutMethod method = this.constructPutMethod(uri, event);
        method.addRequestHeader(IF_MATCH_HEADER, etag);
        HttpMethod toExecute = this.methodInterceptor.doWithMethod((HttpMethod)method, eventOwner);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("putExistingEvent executing " + this.methodToString((HttpMethod)method) + " for " + eventOwner));
        }
        int statusCode = this.httpClient.executeMethod(toExecute);
        return statusCode;
    }

    protected CalendarWithURI purgeDeclinedAttendees(CalendarWithURI calendarWithURI, ICalendarAccount owner) {
        ComponentList componentList = calendarWithURI.getCalendar().getComponents("VEVENT");
        if (componentList.size() != 1) {
            return calendarWithURI;
        }
        for (Object o : componentList) {
            VEvent event = (VEvent)o;
            boolean hasAvailableAppointmentProperty = SchedulingAssistantAppointment.TRUE.equals((Object)event.getProperty("X-UW-AVAILABLE-APPOINTMENT"));
            boolean isAttendingAsOwner = this.eventUtils.isAttendingAsOwner(event, owner);
            if (hasAvailableAppointmentProperty && isAttendingAsOwner) {
                PropertyList attendeeList = this.eventUtils.getAttendeeListFromEvent(event);
                Property visitorLimitProp = event.getProperty("X-UW-AVAILABLE-VISITOR-LIMIT");
                int visitorLimit = Integer.parseInt(visitorLimitProp.getValue());
                for (Object a : attendeeList) {
                    Property attendee = (Property)a;
                    if (!PartStat.DECLINED.equals((Object)attendee.getParameter("PARTSTAT"))) continue;
                    this.log.trace((Object)("found attendee that has DECLINED event: " + attendee));
                    Parameter appointmentRole = attendee.getParameter("X-UW-AVAILABLE-APPOINTMENT-ROLE");
                    if (AppointmentRole.OWNER.equals((Object)appointmentRole)) {
                        this.deleteCalendar(calendarWithURI, owner);
                        this.log.warn((Object)("purgeDeclinedAttendees successfully cancelled appointment due to owner decline " + event));
                        this.applicationEventPublisher.publishEvent((ApplicationEvent)new AutomaticAppointmentCancellationEvent(event, owner, AutomaticAppointmentCancellationEvent.Reason.OWNER_DECLINED));
                        return null;
                    }
                    if (!AppointmentRole.VISITOR.equals((Object)appointmentRole)) continue;
                    int availableVisitorCount = this.eventUtils.getScheduleVisitorCount(event);
                    if (visitorLimit > 1 && availableVisitorCount > 1) {
                        event.getProperties().remove(attendee);
                        try {
                            int statusCode = this.putExistingEvent(owner, event, calendarWithURI.getEtag());
                            this.log.debug((Object)("purgeDeclinedAttendees leave status code: " + statusCode));
                            if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
                                this.log.warn((Object)("purgeDeclinedAttendees successfully removed declined attendee from group appointment " + event));
                                this.applicationEventPublisher.publishEvent((ApplicationEvent)new AutomaticAttendeeRemovalEvent(event, owner, attendee));
                                continue;
                            }
                            if (statusCode == 412) {
                                this.log.warn((Object)("purgeDeclinedAttendees leave failed for " + attendee + " and " + owner + ", appointment was altered"));
                                continue;
                            }
                            throw new CaldavDataAccessException("purgeDeclinedAttendees leave failed for " + attendee + ", " + owner + " failed with unexpected status code: " + statusCode);
                        }
                        catch (HttpException e) {
                            this.log.error((Object)("an HttpException occurred in joinAppointment for " + owner + ", " + attendee));
                            throw new CaldavDataAccessException(e);
                        }
                        catch (IOException e) {
                            this.log.error((Object)("an IOException occurred in joinAppointment for " + owner + ", " + attendee));
                            throw new CaldavDataAccessException(e);
                        }
                    }
                    this.deleteCalendar(calendarWithURI, owner);
                    this.log.warn((Object)("purgeDeclinedAttendees successfully cancelled appointment due to no remaining visitors " + event));
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new AutomaticAppointmentCancellationEvent(event, owner, AutomaticAppointmentCancellationEvent.Reason.NO_REMAINING_VISITORS));
                    return null;
                }
                continue;
            }
            if (!this.log.isTraceEnabled()) continue;
            String eventUid = "not set";
            if (event.getUid() != null) {
                eventUid = event.getUid().getValue();
            }
            this.log.trace((Object)("event (UID=" + eventUid + ") not a candidate for purge, hasAvailableAppointmentProperty=" + hasAvailableAppointmentProperty + ", isAttendingAsOwner=" + isAttendingAsOwner));
        }
        return calendarWithURI;
    }

    private PutMethod constructPutMethod(String uri, VEvent event) {
        PutMethod method = new PutMethod(uri);
        method.addRequestHeader(ICALENDAR_CONTENT_TYPE_HEADER);
        RequestEntity requestEntity = this.caldavDialect.generatePutAppointmentRequestEntity(event);
        method.setRequestEntity(requestEntity);
        return method;
    }

    private VEvent extractSchedulingAssistantAppointment(CalendarWithURI calendar) {
        ComponentList events = calendar.getCalendar().getComponents("VEVENT");
        Validate.isTrue((events.size() == 1 ? 1 : 0) != 0, (String)"expecting calendar with single event");
        return (VEvent)events.get(0);
    }

    private String methodToString(HttpMethod method) {
        StringBuilder result = new StringBuilder();
        result.append(method.getName());
        result.append(" ");
        result.append(method.getPath());
        return result.toString();
    }
}

