/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.caldav;

import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Transp;
import org.apache.commons.lang.Validate;
import org.jasig.schedassist.IAffiliationSource;
import org.jasig.schedassist.model.AppointmentRole;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.DefaultEventUtilsImpl;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public class CaldavEventUtilsImpl
extends DefaultEventUtilsImpl
implements InitializingBean {
    private boolean explicitSetTimeZone = false;
    private String timeZone;
    private TimeZone _timeZone;

    public CaldavEventUtilsImpl(IAffiliationSource affiliationSource) {
        super(affiliationSource);
    }

    public boolean isExplicitSetTimeZone() {
        return this.explicitSetTimeZone;
    }

    @Value(value="caldav.explicitSetTimeZone:false")
    public void setExplicitSetTimeZone(boolean explicitSetTimeZone) {
        this.explicitSetTimeZone = explicitSetTimeZone;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    @Value(value="caldav.systemTimeZone:America/Chicago")
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.isExplicitSetTimeZone()) {
            Validate.notEmpty((String)this.timeZone, (String)"timeZone field cannot be empty if explicitSetTimeZone is true");
            TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
            this._timeZone = registry.getTimeZone(this.timeZone);
            if (null == this._timeZone) {
                throw new IllegalStateException("no timezone found for " + this.timeZone);
            }
        }
    }

    public VEvent constructAvailableAppointment(AvailableBlock block, IScheduleOwner owner, IScheduleVisitor visitor, String eventDescription) {
        VEvent event = super.constructAvailableAppointment(block, owner, visitor, eventDescription);
        event.getProperties().add((Property)this.constructOrganizer(owner.getCalendarAccount()));
        event.getProperties().add((Property)this.generateNewUid());
        if (this.isExplicitSetTimeZone() && this._timeZone != null) {
            DtStart start = event.getStartDate();
            start.setTimeZone(this._timeZone);
            DtEnd end = event.getEndDate();
            end.setTimeZone(this._timeZone);
        }
        return event;
    }

    public Organizer constructOrganizer(ICalendarAccount calendarAccount) {
        ParameterList parameterList = new ParameterList();
        parameterList.add((Parameter)new Cn(calendarAccount.getDisplayName()));
        Organizer organizer = new Organizer(parameterList, CaldavEventUtilsImpl.emailToURI((String)calendarAccount.getEmailAddress()));
        return organizer;
    }

    public boolean willEventCauseConflict(ICalendarAccount calendarAccount, VEvent event) {
        if (event == null) {
            return false;
        }
        Status status = event.getStatus();
        if (status != null && Status.VEVENT_CANCELLED.equals((Object)status)) {
            return false;
        }
        Transp transp = event.getTransparency();
        if (null == transp) {
            return true;
        }
        return Transp.OPAQUE.equals((Object)transp);
    }

    public Attendee constructAvailableAttendee(ICalendarAccount calendarAccount, AppointmentRole role) {
        Attendee attendee = super.constructAvailableAttendee(calendarAccount, role);
        if (AppointmentRole.OWNER.equals((Object)role)) {
            attendee.getParameters().add((Parameter)Role.CHAIR);
        } else if (AppointmentRole.VISITOR.equals((Object)role)) {
            attendee.getParameters().add((Parameter)Role.REQ_PARTICIPANT);
        }
        return attendee;
    }

    protected VEvent convertBlockToReflectionEvent(AvailableBlock block) {
        VEvent reflection = super.convertBlockToReflectionEvent(block);
        reflection.getProperties().add((Property)this.generateNewUid());
        return reflection;
    }

    public Calendar wrapEventInCalendar(VEvent event) {
        Calendar calendar = super.wrapEventInCalendar(event);
        if (this.isExplicitSetTimeZone() && this._timeZone != null) {
            calendar.getComponents().add((Component)this._timeZone.getVTimeZone());
        }
        return calendar;
    }
}

