/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.caldav;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.jasig.schedassist.impl.caldav.HttpCredentialsProvider;
import org.jasig.schedassist.model.ICalendarAccount;
import org.springframework.beans.factory.annotation.Value;

public class DefaultHttpCredentialsProviderImpl
implements HttpCredentialsProvider {
    private String caldavAdminUsername;
    private String caldavAdminPassword;

    @Value(value="${caldav.admin.username}")
    public void setCaldavAdminUsername(String caldavAdminUsername) {
        this.caldavAdminUsername = caldavAdminUsername;
    }

    @Value(value="${caldav.admin.password}")
    public void setCaldavAdminPassword(String caldavAdminPassword) {
        this.caldavAdminPassword = caldavAdminPassword;
    }

    protected String getCaldavAdminUsername() {
        return this.caldavAdminUsername;
    }

    protected String getCaldavAdminPassword() {
        return this.caldavAdminPassword;
    }

    @Override
    public Credentials getCredentials(ICalendarAccount account) {
        UsernamePasswordCredentials adminCredentials = new UsernamePasswordCredentials(this.caldavAdminUsername, this.caldavAdminPassword);
        return adminCredentials;
    }
}

