/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.caldav;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.protocol.HttpContext;

class PreemptiveAuthInterceptor
implements HttpRequestInterceptor {
    static final String PREEMPTIVE_AUTH = "org.jasig.schedassist.impl.caldav.preemptive-auth";
    private final AuthScope caldavAdminAuthScope;
    private final Log log = LogFactory.getLog(this.getClass());

    public PreemptiveAuthInterceptor(AuthScope caldavAdminAuthScope) {
        this.caldavAdminAuthScope = caldavAdminAuthScope;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (authState.getAuthScheme() == null) {
            AuthScheme authScheme = (AuthScheme)context.getAttribute(PREEMPTIVE_AUTH);
            CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            if (authScheme != null) {
                Credentials creds = credsProvider.getCredentials(this.caldavAdminAuthScope);
                if (creds == null) {
                    throw new HttpException("No credentials for preemptive authentication");
                }
                authState.setAuthScheme(authScheme);
                authState.setCredentials(creds);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("successfully set credentials " + creds + " and authScheme " + authScheme + " for request " + request));
                }
            } else {
                this.log.warn((Object)("org.jasig.schedassist.impl.caldav.preemptive-auth authScheme not found in context, failed to set scheme and credentials for " + request));
            }
        } else {
            this.log.warn((Object)("context's authState attribute (" + authState + ") has non-null AuthScheme for request " + request));
        }
    }
}

