/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.caldav;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jasig.schedassist.ConflictExistsException;
import org.jasig.schedassist.IAffiliationSource;
import org.jasig.schedassist.ICalendarDataDao;
import org.jasig.schedassist.NullAffiliationSourceImpl;
import org.jasig.schedassist.SchedulingException;
import org.jasig.schedassist.impl.caldav.CaldavDataAccessException;
import org.jasig.schedassist.impl.caldav.CaldavDialect;
import org.jasig.schedassist.impl.caldav.CaldavEventUtilsImpl;
import org.jasig.schedassist.impl.caldav.CalendarWithURI;
import org.jasig.schedassist.impl.caldav.CredentialsProviderFactory;
import org.jasig.schedassist.impl.caldav.HttpMethodInterceptor;
import org.jasig.schedassist.impl.caldav.NoopHttpMethodInterceptorImpl;
import org.jasig.schedassist.impl.caldav.PreemptiveAuthInterceptor;
import org.jasig.schedassist.impl.caldav.ReportMethod;
import org.jasig.schedassist.impl.caldav.xml.ReportResponseHandlerImpl;
import org.jasig.schedassist.impl.events.AutomaticAppointmentCancellationEvent;
import org.jasig.schedassist.impl.events.AutomaticAttendeeRemovalEvent;
import org.jasig.schedassist.model.AppointmentRole;
import org.jasig.schedassist.model.AvailabilityReflection;
import org.jasig.schedassist.model.AvailableBlock;
import org.jasig.schedassist.model.AvailableSchedule;
import org.jasig.schedassist.model.AvailableVersion;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.DefaultEventUtilsImpl;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IEventUtils;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.SchedulingAssistantAppointment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service(value="caldavCalendarDataDao")
public class CaldavCalendarDataDaoImpl
implements ICalendarDataDao,
InitializingBean {
    static final Header IF_NONE_MATCH_HEADER = new BasicHeader("If-None-Match", "*");
    static final Header ICALENDAR_CONTENT_TYPE_HEADER = new BasicHeader("Content-Type", "text/calendar");
    static final String IF_MATCH_HEADER = "If-Match";
    private static final Header DEPTH_HEADER = new BasicHeader("Depth", "1");
    protected final Log log = LogFactory.getLog(this.getClass());
    private HttpClient httpClient;
    private CredentialsProviderFactory credentialsProviderFactory;
    private HttpHost httpHost;
    private AuthScope caldavAdminAuthScope;
    private IEventUtils eventUtils = new CaldavEventUtilsImpl((IAffiliationSource)new NullAffiliationSourceImpl());
    private CaldavDialect caldavDialect;
    private HttpMethodInterceptor methodInterceptor = new NoopHttpMethodInterceptorImpl();
    private boolean cancelUpdatesVisitorCalendar = false;
    private boolean reflectionEnabled = false;
    private boolean preemptiveAuthenticationEnabled = false;
    private boolean getCalendarPerformsPurgeDeclinedAttendees = true;
    private AuthScheme preemptiveAuthenticationScheme;
    private ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public CredentialsProviderFactory getCredentialsProviderFactory() {
        return this.credentialsProviderFactory;
    }

    @Autowired
    public void setCredentialsProviderFactory(CredentialsProviderFactory credentialsProviderFactory) {
        this.credentialsProviderFactory = credentialsProviderFactory;
    }

    public HttpHost getHttpHost() {
        return this.httpHost;
    }

    @Autowired
    public void setHttpHost(HttpHost httpHost) {
        this.httpHost = httpHost;
    }

    @Autowired
    public void setCaldavAdminAuthScope(AuthScope caldavAdminAuthScope) {
        this.caldavAdminAuthScope = caldavAdminAuthScope;
    }

    public AuthScope getCaldavAdminAuthScope() {
        return this.caldavAdminAuthScope;
    }

    @Autowired(required=false)
    public void setEventUtils(IEventUtils eventUtils) {
        this.eventUtils = eventUtils;
    }

    @Autowired
    public void setCaldavDialect(CaldavDialect caldavDialect) {
        this.caldavDialect = caldavDialect;
    }

    @Autowired(required=false)
    public void setMethodInterceptor(HttpMethodInterceptor methodInterceptor) {
        this.methodInterceptor = methodInterceptor;
    }

    public HttpMethodInterceptor getMethodInterceptor() {
        return this.methodInterceptor;
    }

    @Autowired
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Value(value="${caldav.cancelUpdatesVisitorCalendar:false}")
    public void setCancelUpdatesVisitorCalendar(String cancelUpdatesVisitorCalendar) {
        this.cancelUpdatesVisitorCalendar = Boolean.parseBoolean(cancelUpdatesVisitorCalendar);
    }

    @Value(value="${caldav.reflectionEnabled:false}")
    public void setReflectionEnabled(boolean reflectionEnabled) {
        this.reflectionEnabled = reflectionEnabled;
    }

    public boolean isCancelUpdatesVisitorCalendar() {
        return this.cancelUpdatesVisitorCalendar;
    }

    public void setCancelUpdatesVisitorCalendar(boolean cancelUpdatesVisitorCalendar) {
        this.cancelUpdatesVisitorCalendar = cancelUpdatesVisitorCalendar;
    }

    public IEventUtils getEventUtils() {
        return this.eventUtils;
    }

    public CaldavDialect getCaldavDialect() {
        return this.caldavDialect;
    }

    public boolean isReflectionEnabled() {
        return this.reflectionEnabled;
    }

    public boolean isPreemptiveAuthenticationEnabled() {
        return this.preemptiveAuthenticationEnabled;
    }

    @Value(value="${caldav.preemptiveAuthenticationEnabled:false}")
    public void setPreemptiveAuthenticationEnabled(boolean preemptiveAuthenticationEnabled) {
        this.preemptiveAuthenticationEnabled = preemptiveAuthenticationEnabled;
    }

    public boolean isGetCalendarPerformsPurgeDeclinedAttendees() {
        return this.getCalendarPerformsPurgeDeclinedAttendees;
    }

    @Value(value="${caldav.getCalendarPerformsPurgeDeclinedAttendees:true}")
    public void setGetCalendarPerformsPurgeDeclinedAttendees(boolean getCalendarPerformsPurgeDeclinedAttendees) {
        this.getCalendarPerformsPurgeDeclinedAttendees = getCalendarPerformsPurgeDeclinedAttendees;
    }

    protected AuthScheme identifyScheme(String scheme) {
        if (new BasicScheme().getSchemeName().equalsIgnoreCase(scheme)) {
            return new BasicScheme();
        }
        if (new DigestScheme().getSchemeName().equalsIgnoreCase(scheme)) {
            return new DigestScheme();
        }
        throw new IllegalArgumentException("cannot determine AuthScheme implementation from " + scheme);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.isPreemptiveAuthenticationEnabled()) {
            ((AbstractHttpClient)this.httpClient).addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthInterceptor(this.caldavAdminAuthScope), 0);
            this.preemptiveAuthenticationScheme = this.identifyScheme(this.caldavAdminAuthScope.getScheme());
        }
    }

    public Calendar getCalendar(ICalendarAccount calendarAccount, java.util.Date startDate, java.util.Date endDate) {
        List<CalendarWithURI> calendars = this.getCalendarsInternal(calendarAccount, startDate, endDate);
        Calendar result = this.consolidate(calendars);
        return result;
    }

    public VEvent getExistingAppointment(IScheduleOwner owner, AvailableBlock block) {
        CalendarWithURI calendarWithUri = this.getExistingAppointmentInternal(owner, block.getStartTime(), block.getEndTime());
        if (null != calendarWithUri) {
            ComponentList componentList = calendarWithUri.getCalendar().getComponents("VEVENT");
            return (VEvent)componentList.get(0);
        }
        return null;
    }

    public VEvent createAppointment(IScheduleVisitor visitor, IScheduleOwner owner, AvailableBlock block, String eventDescription) {
        VEvent event = this.eventUtils.constructAvailableAppointment(block, owner, visitor, eventDescription);
        try {
            int statusCode = this.putNewEvent(owner.getCalendarAccount(), event);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("createAppointment status code: " + statusCode));
            }
            if (statusCode == 200 || statusCode == 201) {
                return event;
            }
            throw new CaldavDataAccessException("createAppointment for " + visitor + ", " + owner + ", " + block + " failed with unexpected status code: " + statusCode);
        }
        catch (HttpException e) {
            this.log.error((Object)("an HttpException occurred in createAppointment for " + owner + ", " + visitor + ", " + block));
            throw new CaldavDataAccessException(e);
        }
        catch (IOException e) {
            this.log.error((Object)("an IOException occurred in createAppointment for " + owner + ", " + visitor + ", " + block));
            throw new CaldavDataAccessException(e);
        }
    }

    public void cancelAppointment(IScheduleVisitor visitor, IScheduleOwner owner, VEvent appointment) {
        Date endTime;
        Date startTime = appointment.getStartDate().getDate();
        CalendarWithURI calendarWithURI = this.getExistingAppointmentInternal(owner, (java.util.Date)startTime, (java.util.Date)(endTime = appointment.getEndDate(true).getDate()));
        if (null != calendarWithURI) {
            VEvent event = this.extractSchedulingAssistantAppointment(calendarWithURI);
            Uid eventUid = event.getUid();
            int status = this.deleteCalendar(calendarWithURI, owner.getCalendarAccount());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("cancelAppointment status code " + status + " for " + owner + ", " + eventUid));
            }
            if (this.cancelUpdatesVisitorCalendar) {
                CalendarWithURI visitorCalendarWithURI = this.getExistingAppointmentInternalForVisitor(visitor, (java.util.Date)startTime, (java.util.Date)endTime, eventUid);
                if (visitorCalendarWithURI != null) {
                    status = this.deleteCalendar(visitorCalendarWithURI, visitor.getCalendarAccount());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("cancelAppointment status code " + status + " for " + visitor + ", " + eventUid));
                    }
                } else {
                    this.log.warn((Object)("cancelAppointment unable to locate event in schedule for visitor " + visitor + " with uid " + eventUid));
                }
            }
        } else {
            this.log.warn((Object)("cannot cancelAppointment for " + owner + ", no matching appointment found (" + appointment + ")"));
        }
    }

    protected HttpContext constructHttpContext(ICalendarAccount calendarAccount) {
        CredentialsProvider credentialsProvider = this.credentialsProviderFactory.getCredentialsProvider(calendarAccount);
        BasicHttpContext context = new BasicHttpContext();
        if (this.isPreemptiveAuthenticationEnabled()) {
            if (this.preemptiveAuthenticationScheme == null) {
                throw new IllegalStateException("preemptiveAuthentication is enabled, but the preemptiveAuthenticationScheme is null. Was afterPropertiesSet invoked?");
            }
            context.setAttribute("org.jasig.schedassist.impl.caldav.preemptive-auth", (Object)this.preemptiveAuthenticationScheme);
        }
        context.setAttribute("http.auth.credentials-provider", (Object)credentialsProvider);
        return context;
    }

    protected int deleteCalendar(CalendarWithURI calendarWithURI, ICalendarAccount calendarAccount) {
        int statusCode;
        HttpEntity entity;
        block6: {
            URI uri = this.caldavDialect.resolveCalendarURI(calendarWithURI);
            HttpDelete method = new HttpDelete(uri.toString());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("deleteCalendar executing " + this.methodToString((HttpRequest)method) + " for " + calendarAccount));
            }
            HttpRequest toExecute = this.methodInterceptor.doWithMethod((HttpRequest)method, calendarAccount);
            HttpContext context = this.constructHttpContext(calendarAccount);
            entity = null;
            HttpResponse response = this.httpClient.execute(this.httpHost, toExecute, context);
            entity = response.getEntity();
            statusCode = response.getStatusLine().getStatusCode();
            this.log.debug((Object)("deleteCalendar status code: " + statusCode));
            if (statusCode != 204) break block6;
            int n = statusCode;
            this.quietlyConsume(entity);
            return n;
        }
        try {
            try {
                throw new CaldavDataAccessException("deleteCalendar for " + calendarAccount + ", " + calendarWithURI + " failed with unexpected status code: " + statusCode);
            }
            catch (IOException e) {
                this.log.error((Object)("an IOException occurred in deleteCalendar for " + calendarAccount + ", " + calendarWithURI));
                throw new CaldavDataAccessException(e);
            }
        }
        catch (Throwable throwable) {
            this.quietlyConsume(entity);
            throw throwable;
        }
    }

    public VEvent joinAppointment(IScheduleVisitor visitor, IScheduleOwner owner, VEvent appointment) throws SchedulingException {
        Date endTime;
        Date startTime = appointment.getStartDate().getDate();
        CalendarWithURI calendarWithURI = this.getExistingAppointmentInternal(owner, (java.util.Date)startTime, (java.util.Date)(endTime = appointment.getEndDate(true).getDate()));
        if (null != calendarWithURI) {
            VEvent event = this.extractSchedulingAssistantAppointment(calendarWithURI);
            Attendee attendee = this.eventUtils.constructSchedulingAssistantAttendee(visitor.getCalendarAccount(), AppointmentRole.VISITOR);
            event.getProperties().add((Property)attendee);
            try {
                int statusCode = this.putExistingEvent(owner.getCalendarAccount(), event, calendarWithURI.getEtag());
                this.log.debug((Object)("joinAppointment status code: " + statusCode));
                if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
                    return event;
                }
                if (statusCode == 412) {
                    throw new SchedulingException("joinAppointment failed for " + visitor + " and " + owner + ", appointment was altered");
                }
                throw new CaldavDataAccessException("joinAppointment for " + visitor + ", " + owner + ", " + startTime + " failed with unexpected status code: " + statusCode);
            }
            catch (IOException e) {
                this.log.error((Object)("an IOException occurred in joinAppointment for " + owner + ", " + visitor + ", " + startTime));
                throw new CaldavDataAccessException(e);
            }
        }
        this.log.warn((Object)("cannot joinAppointment for " + owner + ", no matching appointment found (" + appointment + ")"));
        throw new SchedulingException("joinAppointment failed for " + visitor + " and " + owner + ", no matching appointment found");
    }

    public VEvent leaveAppointment(IScheduleVisitor visitor, IScheduleOwner owner, VEvent appointment) throws SchedulingException {
        Date endTime;
        Date startTime = appointment.getStartDate().getDate();
        CalendarWithURI calendarWithURI = this.getExistingAppointmentInternal(owner, (java.util.Date)startTime, (java.util.Date)(endTime = appointment.getEndDate(true).getDate()));
        if (null != calendarWithURI) {
            VEvent event = this.extractSchedulingAssistantAppointment(calendarWithURI);
            Uid eventUid = event.getUid();
            Property attendee = this.eventUtils.getAttendeeForUserFromEvent(event, visitor.getCalendarAccount());
            event.getProperties().remove(attendee);
            try {
                int statusCode = this.putExistingEvent(owner.getCalendarAccount(), event, calendarWithURI.getEtag());
                this.log.debug((Object)("leaveAppointment status code: " + statusCode));
                if (statusCode != 200 && statusCode != 201 && statusCode != 204) {
                    if (statusCode == 412) {
                        throw new SchedulingException("leaveAppointment failed for " + visitor + " and " + owner + ", appointment was altered");
                    }
                    throw new CaldavDataAccessException("leaveAppointment for " + visitor + ", " + owner + ", " + startTime + " failed with unexpected status code: " + statusCode);
                }
                this.log.debug((Object)"leaveAppointment owner calendar update successful");
            }
            catch (IOException e) {
                this.log.error((Object)("an IOException occurred in leaveAppointment for " + owner + ", " + visitor + ", " + startTime));
                throw new CaldavDataAccessException(e);
            }
            if (this.cancelUpdatesVisitorCalendar) {
                CalendarWithURI visitorCalendarWithURI = this.getExistingAppointmentInternalForVisitor(visitor, (java.util.Date)startTime, (java.util.Date)endTime, eventUid);
                if (visitorCalendarWithURI != null) {
                    int status = this.deleteCalendar(visitorCalendarWithURI, visitor.getCalendarAccount());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("leaveAppointment status code " + status + " for " + visitor + ", " + eventUid));
                    }
                } else {
                    this.log.warn((Object)("leaveAppointment unable to locate event in schedule for visitor " + visitor + " with uid " + eventUid));
                }
            }
            return event;
        }
        this.log.warn((Object)("cannot leaveAppointment for " + owner + ", no matching appointment found (" + appointment + ")"));
        throw new SchedulingException("leaveAppointment failed for " + visitor + " and " + owner + ", no matching appointment found");
    }

    public void checkForConflicts(IScheduleOwner owner, AvailableBlock block) throws ConflictExistsException {
        java.util.Date start = DateUtils.addSeconds((java.util.Date)block.getStartTime(), (int)1);
        java.util.Date end = DateUtils.addSeconds((java.util.Date)block.getEndTime(), (int)-1);
        List<CalendarWithURI> calendars = this.getCalendarsInternal(owner.getCalendarAccount(), start, end);
        for (CalendarWithURI calendar : calendars) {
            ComponentList events = calendar.getCalendar().getComponents("VEVENT");
            for (Object component : events) {
                VEvent event = (VEvent)component;
                if (!this.eventUtils.willEventCauseConflict(owner.getCalendarAccount(), event)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("conflict detected for " + owner + " at block " + block + ", event: " + event));
                }
                throw new ConflictExistsException("an appointment already exists for " + block);
            }
        }
    }

    public void reflectAvailableSchedule(IScheduleOwner owner, AvailableSchedule schedule) {
        if (this.reflectionEnabled) {
            if (schedule.isEmpty()) {
                return;
            }
            java.util.Date startDate = CommonDateOperations.beginningOfDay((java.util.Date)schedule.getScheduleStartTime());
            java.util.Date endDate = CommonDateOperations.endOfDay((java.util.Date)schedule.getScheduleEndTime());
            this.purgeAvailableScheduleReflections(owner, startDate, endDate);
            List calendars = this.eventUtils.convertScheduleForReflection(schedule);
            for (Calendar calendar : calendars) {
                Uid uid = this.eventUtils.extractUid(calendar);
                if (uid != null) {
                    try {
                        int statusCode = this.putNewCalendar(owner.getCalendarAccount(), calendar, uid.getValue());
                        if (statusCode == 200 || statusCode == 201 || statusCode == 204) continue;
                        throw new CaldavDataAccessException("reflectAvailableSchedule for " + owner + " failed with unexpected status code: " + statusCode);
                    }
                    catch (HttpException e) {
                        this.log.error((Object)("an HttpException occurred in reflectAvailableSchedule for " + owner));
                        throw new CaldavDataAccessException(e);
                    }
                    catch (IOException e) {
                        this.log.error((Object)("an IOException occurred in reflectAvailableSchedule for " + owner));
                        throw new CaldavDataAccessException(e);
                    }
                }
                this.log.warn((Object)("cannot store reflection for calendar with no UID: " + calendar));
            }
        } else {
            this.log.debug((Object)"experimental feature 'Availability Schedule reflection' disabled by default");
        }
    }

    public void purgeAvailableScheduleReflections(IScheduleOwner owner, java.util.Date startDate, java.util.Date endDate) {
        if (this.reflectionEnabled) {
            List<CalendarWithURI> calendars = this.peekAtAvailableScheduleReflections(owner, startDate, endDate);
            for (CalendarWithURI calendar : calendars) {
                URI uri = this.caldavDialect.resolveCalendarURI(calendar);
                HttpDelete method = new HttpDelete(uri.toString());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("purgeAvailableScheduleReflections executing " + this.methodToString((HttpRequest)method) + " for " + owner + ", " + startDate + ", " + endDate));
                }
                HttpContext context = this.constructHttpContext(owner.getCalendarAccount());
                HttpRequest toExecute = this.methodInterceptor.doWithMethod((HttpRequest)method, owner.getCalendarAccount());
                HttpEntity entity = null;
                try {
                    HttpResponse response = this.httpClient.execute(this.httpHost, toExecute, context);
                    entity = response.getEntity();
                    int statusCode = response.getStatusLine().getStatusCode();
                    this.log.debug((Object)("cancelAppointment status code: " + statusCode));
                    if (statusCode != 204) {
                        throw new CaldavDataAccessException("purgeAvailableScheduleReflections for " + owner + ", " + startDate + ", " + endDate + " failed with unexpected status code: " + statusCode);
                    }
                    this.quietlyConsume(entity);
                }
                catch (IOException e) {
                    try {
                        this.log.error((Object)("an IOException occurred in purgeAvailableScheduleReflections for " + owner + ", " + startDate + ", " + endDate));
                        throw new CaldavDataAccessException(e);
                    }
                    catch (Throwable throwable) {
                        this.quietlyConsume(entity);
                        throw throwable;
                    }
                }
            }
        } else {
            this.log.debug((Object)"experimental feature 'Availability Schedule reflection' disabled");
        }
    }

    public List<CalendarWithURI> peekAtAvailableScheduleReflections(IScheduleOwner owner, java.util.Date startDate, java.util.Date endDate) {
        if (this.reflectionEnabled) {
            List<CalendarWithURI> calendars = this.getCalendarsInternal(owner.getCalendarAccount(), startDate, endDate);
            ArrayList<CalendarWithURI> results = new ArrayList<CalendarWithURI>();
            for (CalendarWithURI calendar : calendars) {
                ComponentList events = calendar.getCalendar().getComponents("VEVENT");
                for (Object component : events) {
                    VEvent event = (VEvent)component;
                    if (!event.getProperties().contains((Object)AvailabilityReflection.TRUE)) continue;
                    results.add(calendar);
                }
            }
            return results;
        }
        this.log.debug((Object)"experimental feature 'Availability Schedule reflection' disabled");
        return Collections.emptyList();
    }

    protected String generateEventUri(ICalendarAccount owner, VEvent event) {
        Validate.notNull((Object)event, (String)"event argument cannot be null");
        Validate.notNull((Object)event.getUid(), (String)"cannot generateEventUri for event with null UID");
        String accountHome = this.caldavDialect.getCalendarAccountHome(owner);
        StringBuilder eventUri = new StringBuilder(accountHome);
        eventUri.append(event.getUid().getValue());
        eventUri.append(".ics");
        return eventUri.toString();
    }

    protected String generateEventUri(ICalendarAccount owner, String eventUid) {
        String accountHome = this.caldavDialect.getCalendarAccountHome(owner);
        StringBuilder eventUri = new StringBuilder(accountHome);
        eventUri.append(eventUid);
        eventUri.append(".ics");
        return eventUri.toString();
    }

    protected List<CalendarWithURI> getCalendarsInternal(ICalendarAccount calendarAccount, java.util.Date startDate, java.util.Date endDate) {
        int statusCode;
        HttpEntity entity;
        block8: {
            List<CalendarWithURI> calendars;
            block9: {
                String accountUri = this.caldavDialect.getCalendarAccountHome(calendarAccount);
                HttpEntity requestEntity = this.caldavDialect.generateGetCalendarRequestEntity(startDate, endDate);
                ReportMethod method = new ReportMethod(accountUri);
                method.setEntity(requestEntity);
                method.addHeader(DEPTH_HEADER);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("getCalendarsInternal executing " + this.methodToString((HttpRequest)method) + " for " + calendarAccount + ", start " + startDate + ", end " + endDate));
                }
                HttpRequest toExecute = this.methodInterceptor.doWithMethod((HttpRequest)method, calendarAccount);
                HttpContext context = this.constructHttpContext(calendarAccount);
                entity = null;
                HttpResponse response = this.httpClient.execute(this.httpHost, toExecute, context);
                entity = response.getEntity();
                statusCode = response.getStatusLine().getStatusCode();
                this.log.debug((Object)("getCalendarsInternal status code: " + statusCode));
                if (statusCode != 200 && statusCode != 207) break block8;
                InputStream content = entity.getContent();
                ReportResponseHandlerImpl reportResponseHandler = new ReportResponseHandlerImpl();
                calendars = reportResponseHandler.extractCalendars(content);
                if (!this.isGetCalendarPerformsPurgeDeclinedAttendees()) break block9;
                ArrayList<CalendarWithURI> results = new ArrayList<CalendarWithURI>();
                for (CalendarWithURI c : calendars) {
                    if (this.purgeDeclinedAttendees(c, calendarAccount) == null) continue;
                    results.add(c);
                }
                ArrayList<CalendarWithURI> arrayList = results;
                this.quietlyConsume(entity);
                return arrayList;
            }
            List<CalendarWithURI> list = calendars;
            this.quietlyConsume(entity);
            return list;
        }
        try {
            try {
                throw new CaldavDataAccessException("unexpected status code: " + statusCode);
            }
            catch (IOException e) {
                this.log.error((Object)("an IOException occurred in getCalendarsInternal for " + calendarAccount + ", " + startDate + ", " + endDate));
                throw new CaldavDataAccessException(e);
            }
        }
        catch (Throwable throwable) {
            this.quietlyConsume(entity);
            throw throwable;
        }
    }

    protected Calendar consolidate(List<CalendarWithURI> calendars) {
        int size = calendars.size();
        if (size == 0) {
            return new Calendar();
        }
        if (size == 1) {
            return calendars.get(0).getCalendar();
        }
        if (size == 2) {
            return this.merge(calendars.get(0).getCalendar(), calendars.get(1).getCalendar());
        }
        Calendar main = this.merge(calendars.get(0).getCalendar(), calendars.get(1).getCalendar());
        List<CalendarWithURI> remaining = calendars.subList(2, calendars.size());
        Iterator<CalendarWithURI> i = remaining.iterator();
        while (i.hasNext()) {
            CalendarWithURI left = i.next();
            Calendar right = new Calendar();
            if (i.hasNext()) {
                right = i.next().getCalendar();
            }
            this.merge(main, left.getCalendar(), right);
        }
        return main;
    }

    protected Calendar merge(Calendar left, Calendar right) {
        Calendar result = new Calendar();
        result.getProperties().add((Property)DefaultEventUtilsImpl.PROD_ID);
        result.getProperties().add((Property)Version.VERSION_2_0);
        this.merge(result, left, right);
        return result;
    }

    protected void merge(Calendar target, Calendar left, Calendar right) {
        HashMap<String, VTimeZone> existingTimezones = new HashMap<String, VTimeZone>();
        for (Component c : left.getComponents()) {
            if ("VTIMEZONE".equals(c.getName())) {
                VTimeZone tz = (VTimeZone)c;
                existingTimezones.put(tz.getTimeZoneId().getValue(), tz);
            }
            target.getComponents().add(c);
        }
        for (Component c : right.getComponents()) {
            if ("VTIMEZONE".equals(c.getName()) && existingTimezones.containsKey(((VTimeZone)c).getTimeZoneId().getValue())) continue;
            target.getComponents().add(c);
        }
    }

    protected CalendarWithURI getExistingAppointmentInternal(IScheduleOwner owner, java.util.Date startTime, java.util.Date endTime) {
        DateTime targetStartTime = new DateTime(startTime);
        DateTime targetEndTime = new DateTime(endTime);
        List<CalendarWithURI> calendars = this.getCalendarsInternal(owner.getCalendarAccount(), startTime, endTime);
        for (CalendarWithURI calendarWithUri : calendars) {
            ComponentList componentList = calendarWithUri.getCalendar().getComponents("VEVENT");
            if (componentList.size() != 1) continue;
            for (Object o : componentList) {
                Property versionProperty;
                VEvent event = (VEvent)o;
                Date eventStart = event.getStartDate().getDate();
                Date eventEnd = event.getEndDate(true).getDate();
                Property schedAssistProperty = event.getProperty("X-UW-AVAILABLE-APPOINTMENT");
                if (!SchedulingAssistantAppointment.TRUE.equals((Object)schedAssistProperty) || !AvailableVersion.AVAILABLE_VERSION_1_2.equals((Object)(versionProperty = event.getProperty("X-UW-AVAILABLE-VERSION"))) || !this.eventUtils.isAttendingAsOwner(event, owner.getCalendarAccount()) || !eventStart.equals(targetStartTime) || !eventEnd.equals(targetEndTime)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("getExistingAppointmentInternal found " + event));
                }
                return calendarWithUri;
            }
        }
        return null;
    }

    protected CalendarWithURI getExistingAppointmentInternalForVisitor(IScheduleVisitor visitor, java.util.Date startTime, java.util.Date endTime, Uid eventUid) {
        DateTime targetStartTime = new DateTime(startTime);
        DateTime targetEndTime = new DateTime(endTime);
        if (eventUid == null) {
            this.log.debug((Object)("cannot call getExistingAppointmentInternal with null eventUid, visitor: " + visitor));
            return null;
        }
        List<CalendarWithURI> calendars = this.getCalendarsInternal(visitor.getCalendarAccount(), startTime, endTime);
        for (CalendarWithURI calendarWithUri : calendars) {
            ComponentList componentList = calendarWithUri.getCalendar().getComponents("VEVENT");
            if (componentList.size() != 1) continue;
            for (Object o : componentList) {
                VEvent event = (VEvent)o;
                Date eventStart = event.getStartDate().getDate();
                Date eventEnd = event.getEndDate(true).getDate();
                Uid uid = event.getUid();
                if (uid == null || !eventUid.equals((Object)uid) || !Status.VEVENT_CANCELLED.equals((Object)event.getStatus()) || !eventStart.equals(targetStartTime) || !eventEnd.equals(targetEndTime)) continue;
                return calendarWithUri;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int putNewCalendar(ICalendarAccount eventOwner, Calendar calendar, String eventUid) throws HttpException, IOException {
        int n;
        String uri = this.generateEventUri(eventOwner, eventUid);
        HttpPut method = this.constructPutMethod(uri, calendar);
        method.addHeader(IF_NONE_MATCH_HEADER);
        HttpRequest toExecute = this.methodInterceptor.doWithMethod((HttpRequest)method, eventOwner);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("putNewCalendar executing " + this.methodToString((HttpRequest)method) + " for " + eventOwner));
        }
        HttpContext context = this.constructHttpContext(eventOwner);
        HttpEntity entity = null;
        try {
            int statusCode;
            HttpResponse response = this.httpClient.execute(this.httpHost, toExecute, context);
            entity = response.getEntity();
            if (this.log.isDebugEnabled()) {
                if (entity == null) {
                    this.log.debug((Object)("putNewCalendar response entity was null, statusline: " + response.getStatusLine()));
                } else {
                    InputStream content = entity.getContent();
                    this.log.debug((Object)("putNewCalendar response body: " + IOUtils.toString((InputStream)content)));
                }
            }
            n = statusCode = response.getStatusLine().getStatusCode();
        }
        catch (Throwable throwable) {
            EntityUtils.consume(entity);
            throw throwable;
        }
        EntityUtils.consume((HttpEntity)entity);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int putNewEvent(ICalendarAccount eventOwner, VEvent event) throws HttpException, IOException {
        int n;
        String uri = this.generateEventUri(eventOwner, event);
        HttpPut method = this.constructPutMethod(uri, event);
        method.addHeader(IF_NONE_MATCH_HEADER);
        HttpRequest toExecute = this.methodInterceptor.doWithMethod((HttpRequest)method, eventOwner);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("putNewEvent executing " + this.methodToString((HttpRequest)method) + " for " + eventOwner));
        }
        HttpContext context = this.constructHttpContext(eventOwner);
        HttpEntity entity = null;
        try {
            int statusCode;
            HttpResponse response = this.httpClient.execute(this.httpHost, toExecute, context);
            entity = response.getEntity();
            if (this.log.isDebugEnabled()) {
                if (entity == null) {
                    this.log.debug((Object)("putNewEvent response entity was null, statusline: " + response.getStatusLine()));
                } else {
                    InputStream content = entity.getContent();
                    this.log.debug((Object)("putNewEvent response body: " + IOUtils.toString((InputStream)content)));
                }
            }
            n = statusCode = response.getStatusLine().getStatusCode();
        }
        catch (Throwable throwable) {
            EntityUtils.consume(entity);
            throw throwable;
        }
        EntityUtils.consume((HttpEntity)entity);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int putExistingEvent(ICalendarAccount eventOwner, VEvent event, String etag) throws IOException {
        int n;
        String uri = this.generateEventUri(eventOwner, event);
        HttpPut method = this.constructPutMethod(uri, event);
        method.addHeader(IF_MATCH_HEADER, etag);
        HttpRequest toExecute = this.methodInterceptor.doWithMethod((HttpRequest)method, eventOwner);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("putExistingEvent executing " + this.methodToString((HttpRequest)method) + " for " + eventOwner));
        }
        HttpContext context = this.constructHttpContext(eventOwner);
        HttpEntity entity = null;
        try {
            int statusCode;
            HttpResponse response = this.httpClient.execute(this.httpHost, toExecute, context);
            entity = response.getEntity();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("putExistingEvent response entity is null, response status line: " + response.getStatusLine()));
            }
            n = statusCode = response.getStatusLine().getStatusCode();
        }
        catch (Throwable throwable) {
            EntityUtils.consume(entity);
            throw throwable;
        }
        EntityUtils.consume((HttpEntity)entity);
        return n;
    }

    protected CalendarWithURI purgeDeclinedAttendees(CalendarWithURI calendarWithURI, ICalendarAccount owner) {
        ComponentList componentList = calendarWithURI.getCalendar().getComponents("VEVENT");
        if (componentList.size() != 1) {
            return calendarWithURI;
        }
        for (Object o : componentList) {
            VEvent event = (VEvent)o;
            if (event.getStartDate().getDate().before(new java.util.Date())) continue;
            boolean hasAvailableAppointmentProperty = SchedulingAssistantAppointment.TRUE.equals((Object)event.getProperty("X-UW-AVAILABLE-APPOINTMENT"));
            boolean isAttendingAsOwner = this.eventUtils.isAttendingAsOwner(event, owner);
            if (hasAvailableAppointmentProperty && isAttendingAsOwner) {
                PropertyList attendeeList = this.eventUtils.getAttendeeListFromEvent(event);
                Property visitorLimitProp = event.getProperty("X-UW-AVAILABLE-VISITOR-LIMIT");
                int visitorLimit = Integer.parseInt(visitorLimitProp.getValue());
                for (Object a : attendeeList) {
                    Property attendee = (Property)a;
                    if (!PartStat.DECLINED.equals((Object)attendee.getParameter("PARTSTAT"))) continue;
                    this.log.trace((Object)("found attendee that has DECLINED event: " + attendee));
                    Parameter appointmentRole = attendee.getParameter("X-UW-AVAILABLE-APPOINTMENT-ROLE");
                    if (AppointmentRole.OWNER.equals((Object)appointmentRole)) {
                        this.deleteCalendar(calendarWithURI, owner);
                        this.log.warn((Object)("purgeDeclinedAttendees successfully cancelled appointment due to owner decline " + event));
                        this.applicationEventPublisher.publishEvent((ApplicationEvent)new AutomaticAppointmentCancellationEvent(event, owner, AutomaticAppointmentCancellationEvent.Reason.OWNER_DECLINED));
                        return null;
                    }
                    if (!AppointmentRole.VISITOR.equals((Object)appointmentRole)) continue;
                    int availableVisitorCount = this.eventUtils.getScheduleVisitorCount(event);
                    if (visitorLimit > 1 && availableVisitorCount > 1) {
                        event.getProperties().remove(attendee);
                        try {
                            int statusCode = this.putExistingEvent(owner, event, calendarWithURI.getEtag());
                            this.log.debug((Object)("purgeDeclinedAttendees leave status code: " + statusCode));
                            if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
                                this.log.warn((Object)("purgeDeclinedAttendees successfully removed declined attendee from group appointment " + event));
                                this.applicationEventPublisher.publishEvent((ApplicationEvent)new AutomaticAttendeeRemovalEvent(event, owner, attendee));
                                continue;
                            }
                            if (statusCode == 412) {
                                this.log.warn((Object)("purgeDeclinedAttendees leave failed for " + attendee + " and " + owner + ", appointment was altered"));
                                continue;
                            }
                            throw new CaldavDataAccessException("purgeDeclinedAttendees leave failed for " + attendee + ", " + owner + " failed with unexpected status code: " + statusCode);
                        }
                        catch (IOException e) {
                            this.log.error((Object)("an IOException occurred in joinAppointment for " + owner + ", " + attendee));
                            throw new CaldavDataAccessException(e);
                        }
                    }
                    this.deleteCalendar(calendarWithURI, owner);
                    this.log.warn((Object)("purgeDeclinedAttendees successfully cancelled appointment due to no remaining visitors " + event));
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new AutomaticAppointmentCancellationEvent(event, owner, AutomaticAppointmentCancellationEvent.Reason.NO_REMAINING_VISITORS));
                    return null;
                }
                continue;
            }
            if (!this.log.isTraceEnabled()) continue;
            String eventUid = "not set";
            if (event.getUid() != null) {
                eventUid = event.getUid().getValue();
            }
            this.log.trace((Object)("event (UID=" + eventUid + ") not a candidate for purge, hasAvailableAppointmentProperty=" + hasAvailableAppointmentProperty + ", isAttendingAsOwner=" + isAttendingAsOwner));
        }
        return calendarWithURI;
    }

    HttpPut constructPutMethod(String uri, VEvent event) {
        HttpPut method = new HttpPut(uri);
        method.addHeader(ICALENDAR_CONTENT_TYPE_HEADER);
        HttpEntity requestEntity = this.caldavDialect.generatePutAppointmentRequestEntity(event);
        method.setEntity(requestEntity);
        return method;
    }

    HttpPut constructPutMethod(String uri, Calendar calendar) {
        HttpPut method = new HttpPut(uri);
        method.addHeader(ICALENDAR_CONTENT_TYPE_HEADER);
        HttpEntity requestEntity = this.caldavDialect.generatePutAppointmentRequestEntity(calendar);
        method.setEntity(requestEntity);
        return method;
    }

    VEvent extractSchedulingAssistantAppointment(CalendarWithURI calendar) {
        ComponentList events = calendar.getCalendar().getComponents("VEVENT");
        Validate.isTrue((events.size() == 1 ? 1 : 0) != 0, (String)"expecting calendar with single event");
        return (VEvent)events.get(0);
    }

    String methodToString(HttpRequest method) {
        return method.getRequestLine().toString();
    }

    void quietlyConsume(HttpEntity entity) {
        try {
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            this.log.info((Object)"caught IOException from EntityUtils#consume", (Throwable)e);
        }
    }
}

