/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


package org.jasig.schedassist.web.profiles;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * {@link Controller} to display the search form for public profiles.
 *  
 * @author Nicholas Blair, nblair@doit.wisc.edu
 * @version $Id: ProfileSearchController.java 2421 2010-08-30 15:46:00Z npblair $
 */
@Controller
public final class ProfileSearchController  {
	protected static final String VIEW_NAME = "profiles/search-public-listing";
	private String sitesearchValue = "tools.wisccal.wisc.edu/available/";
	@RequestMapping("/public/index.html")
	protected String displaySearchForm(ModelMap model) {
		model.addAttribute("sitesearchValue", sitesearchValue);
		return VIEW_NAME;
	}
}
