/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.admin;

import java.util.List;
import org.jasig.schedassist.CalendarAccountNotFoundException;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.MutableRelationshipDao;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.impl.visitor.VisitorDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.web.admin.ModifyAdhocRelationshipFormBackingObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/admin/relationships-for-owner.html"})
public class RelationshipsForOwnerController {
    private ICalendarAccountDao calendarAccountDao;
    private OwnerDao ownerDao;
    private VisitorDao visitorDao;
    private MutableRelationshipDao mutableRelationshipDao;

    @Autowired
    public void setCalendarAccountDao(@Qualifier(value="people") ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setVisitorDao(VisitorDao visitorDao) {
        this.visitorDao = visitorDao;
    }

    @Autowired
    public void setMutableRelationshipDao(MutableRelationshipDao mutableRelationshipDao) {
        this.mutableRelationshipDao = mutableRelationshipDao;
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String showRelationships(@RequestParam(value="id", required=false, defaultValue="0") long ownerId, ModelMap model) throws NotAVisitorException {
        IScheduleOwner owner;
        model.addAttribute("id", (Object)ownerId);
        if (ownerId != 0L && null != (owner = this.ownerDao.locateOwnerByAvailableId(ownerId))) {
            model.addAttribute("owner", (Object)owner);
            List relationships = this.mutableRelationshipDao.forOwner(owner);
            model.addAttribute("relationships", (Object)relationships);
        }
        return "admin/relationships-for-owner";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String destroyAdhocRelationship(ModifyAdhocRelationshipFormBackingObject fbo, ModelMap model) throws CalendarAccountNotFoundException, NotAVisitorException {
        IScheduleOwner owner = this.ownerDao.locateOwnerByAvailableId(fbo.getOwnerId());
        if (null != owner) {
            model.addAttribute("owner", (Object)owner);
            ICalendarAccount visitorUser = this.calendarAccountDao.getCalendarAccount(fbo.getVisitorUsername());
            if (null == visitorUser) {
                throw new CalendarAccountNotFoundException(fbo.getVisitorUsername() + " does not exist or is not eligible for WiscCal");
            }
            IScheduleVisitor visitor = this.visitorDao.toVisitor(visitorUser);
            model.addAttribute("visitor", (Object)visitor);
            this.mutableRelationshipDao.destroyRelationship(owner, visitor);
            return "admin/destroy-adhoc-relationship-success";
        }
        return "admin/not-modified";
    }
}

